/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.utilities;

import android.content.Context;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.content.res.Resources;
import java.util.Locale;

public class LanguageManager {
    private final Context context;
    private final SharedPreferences sharedPreferences;

    public LanguageManager(Context ctx) {
        this.context = ctx;
        this.sharedPreferences = this.context.getSharedPreferences("APP_PREFERENCES", 0);
    }

    public void updateLanguage(String langCode) {
        Locale locale = new Locale(langCode);
        Locale.setDefault(locale);
        Resources resources = this.context.getResources();
        Configuration configuration = resources.getConfiguration();
        configuration.locale = locale;
        configuration.setLayoutDirection(locale);
        resources.updateConfiguration(configuration, resources.getDisplayMetrics());
        this.setLanguage(langCode);
    }

    public String getLangCode() {
        return this.sharedPreferences.getString("appLanguage", "fr");
    }

    private void setLanguage(String langCode) {
        SharedPreferences.Editor editor = this.sharedPreferences.edit();
        editor.putString("appLanguage", langCode);
        editor.apply();
    }
}

