/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.fragment;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.widget.CompositePageTransformer;
import androidx.viewpager2.widget.MarginPageTransformer;
import androidx.viewpager2.widget.ViewPager2;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.GamesAdapter;
import com.ElyStudio.leGaou.adapter.TrendingGamesAdapter;
import com.ElyStudio.leGaou.databinding.FragmentGamesBinding;
import com.ElyStudio.leGaou.models.Games;
import com.ElyStudio.leGaou.models.GetGameScreenData;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.GridViewSpacing;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class GamesFragment
extends Fragment {
    FragmentGamesBinding binding;
    Context contextFragment;
    public static final String TAG = "GAMES_FRAGMENT";
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentGamesBinding.inflate(inflater, container, false);
        this.getGamesScreenData();
        return this.binding.getRoot();
    }

    private void getGamesScreenData() {
        if (CheckInternetConnection.isInternetConnected(this.getContextNullSafety())) {
            Call<GetGameScreenData> getGameScreenDataCall = ApiController.getInstance().getApi().getGameScreenData();
            getGameScreenDataCall.enqueue((Callback)new Callback<GetGameScreenData>(){

                public void onResponse(Call<GetGameScreenData> call, Response<GetGameScreenData> response) {
                    if (((GetGameScreenData)response.body()).getStatusCode() == 0) {
                        int adEnabled = ((GetGameScreenData)response.body()).getAdEnabled();
                        String interstitialAdId = ((GetGameScreenData)response.body()).getInterstitialAdId();
                        if (((GetGameScreenData)response.body()).getTrendingGameList() != null) {
                            GamesFragment.this.setTrendingGamesViewPager(((GetGameScreenData)response.body()).getTrendingGameList(), GamesFragment.this.getContextNullSafety(), adEnabled, interstitialAdId);
                        }
                        if (((GetGameScreenData)response.body()).getGamesList() != null) {
                            GamesFragment.this.setGamesRecyclerView(((GetGameScreenData)response.body()).getGamesList(), GamesFragment.this.getContextNullSafety(), adEnabled, interstitialAdId);
                        }
                    } else {
                        QuizzeSnackBar.showSnackBar(GamesFragment.this.getContextNullSafety(), (View)GamesFragment.this.binding.getRoot(), GamesFragment.this.getResources().getString(2131886416), GamesFragment.this.getResources().getColor(2131034225));
                        GamesFragment.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<GetGameScreenData> call, Throwable t) {
                    Log.d((String)GamesFragment.TAG, (String)("getGameScreenDataCall Failure = " + t.getLocalizedMessage()));
                    GamesFragment.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    private void setGamesRecyclerView(List<Games> gamesList, Context context, int adEnabled, String interstitialAdId) {
        RecyclerView gamesRecyclerview = this.binding.gamesRecyclerView;
        GamesAdapter gamesAdapter = new GamesAdapter(context, (Activity)this.getActivityNullSafety(), gamesList, adEnabled, interstitialAdId);
        GridLayoutManager layoutManager = new GridLayoutManager(context, 2, 1, false);
        gamesRecyclerview.addItemDecoration((RecyclerView.ItemDecoration)new GridViewSpacing(2, 40, false));
        gamesRecyclerview.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        gamesRecyclerview.setAdapter((RecyclerView.Adapter)gamesAdapter);
    }

    private void setTrendingGamesViewPager(List<Games> gamesList, Context context, int adEnabled, String interstitialAdId) {
        ViewPager2 trendingGamesViewPager = this.binding.trendingGameViewPager;
        trendingGamesViewPager.setClipToPadding(false);
        trendingGamesViewPager.setClipChildren(false);
        trendingGamesViewPager.setOffscreenPageLimit(5);
        TrendingGamesAdapter gamesAdapter = new TrendingGamesAdapter(gamesList, context, (Activity)this.getActivityNullSafety(), adEnabled, interstitialAdId);
        trendingGamesViewPager.getChildAt(0).setOverScrollMode(2);
        CompositePageTransformer compositePageTransformer = new CompositePageTransformer();
        compositePageTransformer.addTransformer((ViewPager2.PageTransformer)new MarginPageTransformer(40));
        compositePageTransformer.addTransformer(new ViewPager2.PageTransformer(){

            public void transformPage(@NonNull View page, float position) {
                float r = 1.0f - Math.abs(position);
                page.setScaleY(0.85f + r * 0.15f);
            }
        });
        trendingGamesViewPager.setPageTransformer((ViewPager2.PageTransformer)compositePageTransformer);
        trendingGamesViewPager.setAdapter((RecyclerView.Adapter)gamesAdapter);
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.contextFragment = context;
    }

    public Context getContextNullSafety() {
        if (this.getContext() != null) {
            return this.getContext();
        }
        if (this.getActivity() != null) {
            return this.getActivity();
        }
        if (this.contextFragment != null) {
            return this.contextFragment;
        }
        if (this.getView() != null && this.getView().getContext() != null) {
            return this.getView().getContext();
        }
        if (this.requireContext() != null) {
            return this.requireContext();
        }
        if (this.requireActivity() != null) {
            return this.requireActivity();
        }
        if (this.requireView() != null && this.requireView().getContext() != null) {
            return this.requireView().getContext();
        }
        return null;
    }

    public FragmentActivity getActivityNullSafety() {
        if (this.getContextNullSafety() != null && this.getContextNullSafety() instanceof FragmentActivity) {
            return (FragmentActivity)this.getContextNullSafety();
        }
        return null;
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        final View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)this.getActivityNullSafety().findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected(GamesFragment.this.getContextNullSafety())) {
                    GamesFragment.this.getGamesScreenData();
                    GamesFragment.this.noInternetBottomSheet.cancel();
                } else {
                    QuizzeSnackBar.showSnackBar(GamesFragment.this.getContextNullSafety(), view, GamesFragment.this.getActivityNullSafety().getResources().getString(2131886351), GamesFragment.this.getActivityNullSafety().getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165481));
        if (!this.getActivityNullSafety().isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)this.getActivityNullSafety().findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GamesFragment.this.startActivity(new Intent((Context)GamesFragment.this.getActivityNullSafety(), SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GamesFragment.this.errorOccurredBottomSheet.cancel();
                GamesFragment.this.getGamesScreenData();
            }
        });
        if (!this.getActivityNullSafety().isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

