/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.fragment;

import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AppCompatDelegate;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.ElyStudio.leGaou.activities.AboutUsScreen;
import com.ElyStudio.leGaou.activities.ChangeLanguageScreen;
import com.ElyStudio.leGaou.activities.OnboardingScreen;
import com.ElyStudio.leGaou.activities.PlayingHistoryScreen;
import com.ElyStudio.leGaou.activities.PrivacyPolicyScreen;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.activities.UserProfileScreen;
import com.ElyStudio.leGaou.activities.WalletScreen;
import com.ElyStudio.leGaou.databinding.FragmentAccountBinding;
import com.ElyStudio.leGaou.models.AppLanguage;
import com.ElyStudio.leGaou.models.UserData;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.Task;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import com.google.firebase.messaging.FirebaseMessaging;
import com.squareup.picasso.Picasso;
import java.util.ArrayList;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AccountFragment
extends Fragment {
    FragmentAccountBinding binding;
    Context contextFragment;
    SharedPreferences sharedPreferences;
    SharedPreferences.Editor editor;
    boolean appMode;
    boolean isNotificationEnabled;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;
    BottomSheetDialog logoutBottomSheet;
    List<AppLanguage> appLanguageList;
    public static final String TAG = "ACCOUNT_FRAGMENT";

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        this.binding = FragmentAccountBinding.inflate(inflater, container, false);
        this.getUserData();
        this.appLanguageList = new ArrayList<AppLanguage>();
        this.sharedPreferences = this.getContextNullSafety().getSharedPreferences("APP_PREFERENCES", 0);
        this.editor = this.sharedPreferences.edit();
        this.appMode = this.sharedPreferences.getBoolean("appColorMode", false);
        this.isNotificationEnabled = this.sharedPreferences.getBoolean("notificationEnabled", false);
        this.binding.walledCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent(AccountFragment.this.getContextNullSafety(), WalletScreen.class));
            }
        });
        this.binding.historyCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent(AccountFragment.this.getContextNullSafety(), PlayingHistoryScreen.class));
            }
        });
        this.binding.privacyPolicyCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent(AccountFragment.this.getContextNullSafety(), PrivacyPolicyScreen.class));
            }
        });
        this.binding.aboutUsCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent(AccountFragment.this.getContextNullSafety(), AboutUsScreen.class));
            }
        });
        this.binding.editBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent(AccountFragment.this.getContextNullSafety(), UserProfileScreen.class));
            }
        });
        this.binding.supportCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent(AccountFragment.this.getContextNullSafety(), SupportScreen.class));
            }
        });
        this.binding.appColorModeSwitch.setChecked(this.appMode);
        this.binding.appColorModeSwitch.setOnCheckedChangeListener(new CompoundButton.OnCheckedChangeListener(){

            public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
                AccountFragment.this.editor.putBoolean("appColorMode", isChecked);
                AccountFragment.this.editor.apply();
                if (isChecked) {
                    AppCompatDelegate.setDefaultNightMode((int)2);
                } else {
                    AppCompatDelegate.setDefaultNightMode((int)1);
                }
            }
        });
        this.binding.notificationSwitch.setChecked(this.isNotificationEnabled);
        this.binding.notificationSwitch.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (AccountFragment.this.isNotificationEnabled) {
                    FirebaseMessaging.getInstance().unsubscribeFromTopic("NOTIFICATIONS").addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                        public void onComplete(@NonNull Task<Void> task) {
                            if (task.isSuccessful()) {
                                AccountFragment.this.editor.putBoolean("notificationEnabled", false);
                                AccountFragment.this.editor.apply();
                            }
                        }
                    });
                } else {
                    FirebaseMessaging.getInstance().subscribeToTopic("NOTIFICATIONS").addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

                        public void onComplete(@NonNull Task<Void> task) {
                            if (task.isSuccessful()) {
                                AccountFragment.this.editor.putBoolean("notificationEnabled", true);
                                AccountFragment.this.editor.apply();
                            }
                        }
                    });
                }
            }
        });
        this.binding.changeLanguageCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent((Context)AccountFragment.this.getActivityNullSafety(), ChangeLanguageScreen.class));
            }
        });
        this.binding.logoutCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.showLogoutBottomSheet();
            }
        });
        return this.binding.getRoot();
    }

    private void getUserData() {
        if (CheckInternetConnection.isInternetConnected(this.getContextNullSafety())) {
            Call<UserData> getUserDataCall = ApiController.getInstance().getApi().getUserData(FirebaseAuth.getInstance().getUid());
            getUserDataCall.enqueue((Callback)new Callback<UserData>(){

                public void onResponse(Call<UserData> call, Response<UserData> response) {
                    if (((UserData)response.body()).getStatusCode() == 0) {
                        AccountFragment.this.setUserData((UserData)response.body());
                    } else {
                        Log.d((String)AccountFragment.TAG, (String)((UserData)response.body()).getMessage());
                        AccountFragment.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<UserData> call, Throwable t) {
                    Log.d((String)AccountFragment.TAG, (String)("getUserDataCall Failure = " + t.getLocalizedMessage()));
                    AccountFragment.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    private void setUserData(UserData userData) {
        if (!userData.getAvatar().trim().equals("")) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + userData.getAvatar()).into(this.binding.userAccountAvatar);
        } else {
            this.binding.userAccountAvatar.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165413));
        }
        if (!userData.getUserLevelIcon().trim().equals("")) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + userData.getUserLevelIcon()).into(this.binding.userLevelIcon);
        } else {
            this.binding.userLevelIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165413));
        }
        this.binding.accountUserName.setText((CharSequence)userData.getName());
        this.binding.userAccountEmail.setText((CharSequence)userData.getEmail());
        this.binding.accountUserLevel.setText((CharSequence)userData.getUserLevel());
        this.binding.accountUserCoins.setText((CharSequence)String.valueOf(userData.getCoins()));
        this.binding.accountUserTotalCoins.setText((CharSequence)String.valueOf(userData.getTotalCoins()));
    }

    public void onAttach(@NonNull Context context) {
        super.onAttach(context);
        this.contextFragment = context;
    }

    public Context getContextNullSafety() {
        if (this.getContext() != null) {
            return this.getContext();
        }
        if (this.getActivity() != null) {
            return this.getActivity();
        }
        if (this.contextFragment != null) {
            return this.contextFragment;
        }
        if (this.getView() != null && this.getView().getContext() != null) {
            return this.getView().getContext();
        }
        if (this.requireContext() != null) {
            return this.requireContext();
        }
        if (this.requireActivity() != null) {
            return this.requireActivity();
        }
        if (this.requireView() != null && this.requireView().getContext() != null) {
            return this.requireView().getContext();
        }
        return null;
    }

    public FragmentActivity getActivityNullSafety() {
        if (this.getContextNullSafety() != null && this.getContextNullSafety() instanceof FragmentActivity) {
            return (FragmentActivity)this.getContextNullSafety();
        }
        return null;
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        final View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)this.getActivityNullSafety().findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected(AccountFragment.this.getContextNullSafety())) {
                    AccountFragment.this.getUserData();
                    AccountFragment.this.noInternetBottomSheet.cancel();
                } else {
                    QuizzeSnackBar.showSnackBar(AccountFragment.this.getContextNullSafety(), view, AccountFragment.this.getActivityNullSafety().getResources().getString(2131886351), AccountFragment.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165481));
        if (!this.getActivityNullSafety().isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog(this.getContextNullSafety());
        View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492934, (ViewGroup)this.getActivityNullSafety().findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this.getContextNullSafety(), (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getActivityNullSafety().getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.startActivity(new Intent((Context)AccountFragment.this.getActivityNullSafety(), SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.errorOccurredBottomSheet.cancel();
                AccountFragment.this.getUserData();
            }
        });
        if (!this.getActivityNullSafety().isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }

    public void showLogoutBottomSheet() {
        this.logoutBottomSheet = new BottomSheetDialog((Context)this.getActivityNullSafety());
        View view = LayoutInflater.from((Context)this.getContextNullSafety()).inflate(2131492945, (ViewGroup)((ConstraintLayout)this.binding.getRoot().findViewById(2131296696)), false);
        this.logoutBottomSheet.setContentView(view);
        Button cancelButton = (Button)this.logoutBottomSheet.findViewById(2131296427);
        Button logoutButton = (Button)this.logoutBottomSheet.findViewById(2131296695);
        cancelButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                AccountFragment.this.logoutBottomSheet.cancel();
            }
        });
        logoutButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                FirebaseAuth.getInstance().signOut();
                AccountFragment.this.startActivity(new Intent((Context)AccountFragment.this.getActivityNullSafety(), OnboardingScreen.class));
                AccountFragment.this.getActivityNullSafety().finish();
            }
        });
        if (!this.getActivityNullSafety().isFinishing()) {
            this.logoutBottomSheet.show();
        }
    }
}

