/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.GameWebViewScreen;
import com.ElyStudio.leGaou.models.Games;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.material.card.MaterialCardView;
import com.squareup.picasso.Picasso;
import java.util.List;

public class TrendingGamesAdapter
extends RecyclerView.Adapter<TrendingGamesViewHolder> {
    private List<Games> trendingGamesList;
    private Context context;
    private Activity activity;
    private int adEnabled;
    private String interstitialAdId;
    private InterstitialAd mInterstitialAd;
    public static final String TAG = "TRENDING_GAME_ADAPTER";

    public TrendingGamesAdapter(List<Games> trendingGamesList, Context context, Activity activity, int adEnabled, String interstitialAdId) {
        this.trendingGamesList = trendingGamesList;
        this.context = context;
        this.activity = activity;
        this.adEnabled = adEnabled;
        this.interstitialAdId = interstitialAdId;
    }

    @NonNull
    public TrendingGamesViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new TrendingGamesViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131493016, parent, false));
    }

    public void onBindViewHolder(@NonNull TrendingGamesViewHolder holder, int position) {
        int bgColor;
        int textColor;
        this.loadInterstitialAd();
        final Games games = this.trendingGamesList.get(position);
        holder.gameName.setText((CharSequence)games.getName());
        if (games.getColorCode() == 1) {
            textColor = this.context.getResources().getColor(2131034759);
            bgColor = this.context.getResources().getColor(2131034750);
        } else if (games.getColorCode() == 2) {
            textColor = this.context.getResources().getColor(2131034760);
            bgColor = this.context.getResources().getColor(2131034751);
        } else if (games.getColorCode() == 3) {
            textColor = this.context.getResources().getColor(2131034761);
            bgColor = this.context.getResources().getColor(2131034752);
        } else if (games.getColorCode() == 4) {
            textColor = this.context.getResources().getColor(2131034762);
            bgColor = this.context.getResources().getColor(2131034753);
        } else if (games.getColorCode() == 5) {
            textColor = this.context.getResources().getColor(2131034763);
            bgColor = this.context.getResources().getColor(2131034754);
        } else if (games.getColorCode() == 6) {
            textColor = this.context.getResources().getColor(2131034764);
            bgColor = this.context.getResources().getColor(2131034755);
        } else if (games.getColorCode() == 7) {
            textColor = this.context.getResources().getColor(2131034765);
            bgColor = this.context.getResources().getColor(2131034756);
        } else if (games.getColorCode() == 8) {
            textColor = this.context.getResources().getColor(2131034766);
            bgColor = this.context.getResources().getColor(2131034757);
        } else {
            textColor = this.context.getResources().getColor(2131034742);
            bgColor = this.context.getResources().getColor(2131034758);
        }
        if (!games.getIcon().trim().equals("")) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + games.getIcon()).into(holder.gameIcon);
        }
        holder.gameCard.setCardBackgroundColor(bgColor);
        holder.playGameBtn.setBackgroundColor(textColor);
        holder.gameName.setTextColor(textColor);
        holder.playGameBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (TrendingGamesAdapter.this.mInterstitialAd != null) {
                    TrendingGamesAdapter.this.mInterstitialAd.show(TrendingGamesAdapter.this.activity);
                    TrendingGamesAdapter.this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                        public void onAdDismissedFullScreenContent() {
                            super.onAdDismissedFullScreenContent();
                            TrendingGamesAdapter.this.startGame(games);
                        }
                    });
                } else {
                    TrendingGamesAdapter.this.startGame(games);
                }
            }
        });
    }

    public int getItemCount() {
        return this.trendingGamesList.size();
    }

    private void loadInterstitialAd() {
        if (this.adEnabled == 1) {
            AdRequest adRequest = new AdRequest.Builder().build();
            InterstitialAd.load((Context)this.context, (String)this.interstitialAdId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)TrendingGamesAdapter.TAG, (String)("Failed to load interstitial ad = " + loadAdError));
                    TrendingGamesAdapter.this.mInterstitialAd = null;
                }

                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded((Object)interstitialAd);
                    TrendingGamesAdapter.this.mInterstitialAd = interstitialAd;
                }
            });
        }
    }

    private void startGame(Games games) {
        Intent intent = new Intent(this.context, GameWebViewScreen.class);
        intent.putExtra("gameUrl", games.getGameUrl());
        intent.putExtra("gameName", games.getName());
        intent.putExtra("adEnabled", this.adEnabled);
        intent.putExtra("interstitialAdId", this.interstitialAdId);
        this.context.startActivity(intent);
    }

    public static class TrendingGamesViewHolder
    extends RecyclerView.ViewHolder {
        ImageView gameIcon;
        TextView gameName;
        MaterialCardView gameCard;
        Button playGameBtn;

        public TrendingGamesViewHolder(@NonNull View itemView) {
            super(itemView);
            this.gameIcon = (ImageView)itemView.findViewById(2131296568);
            this.gameName = (TextView)itemView.findViewById(2131297086);
            this.gameCard = (MaterialCardView)itemView.findViewById(2131297085);
            this.playGameBtn = (Button)itemView.findViewById(2131296833);
        }
    }
}

