/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.activities.QuizScreen;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.Quiz;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.airbnb.lottie.LottieAnimationView;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.card.MaterialCardView;
import com.google.firebase.auth.FirebaseAuth;
import com.squareup.picasso.Picasso;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class QuizAdapter
extends RecyclerView.Adapter<QuizViewHolder> {
    private final Context context;
    private final List<Quiz> quizList;
    private final Activity activity;
    private final View view;
    private final int userCoins;
    private final int watchEarnReward;
    private final int adEnabled;
    private final String nativeAdId;
    private final String interstitialAdId;
    private final String rewardedAdId;
    BottomSheetDialog quizBottomSheet;
    BottomSheetDialog noCoinsBottomSheet;
    private RewardedAd mRewardedAd;
    private InterstitialAd mInterstitialAd;
    public static final String TAG = "QUIZ_ADAPTER";
    LottieAnimationView loadingAnimationAd;
    LottieAnimationView quizLoadingAnimation;
    MaterialCardView watchAdBtn;
    Button playButton;

    public QuizAdapter(Context context, List<Quiz> quizList, Activity activity, View view, int userCoins, int watchEarnReward, int adEnabled, String nativeAdId, String interstitialAdId, String rewardedAdId) {
        this.context = context;
        this.quizList = quizList;
        this.activity = activity;
        this.view = view;
        this.userCoins = userCoins;
        this.watchEarnReward = watchEarnReward;
        this.adEnabled = adEnabled;
        this.nativeAdId = nativeAdId;
        this.interstitialAdId = interstitialAdId;
        this.rewardedAdId = rewardedAdId;
    }

    @NonNull
    public QuizViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new QuizViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131493007, parent, false));
    }

    public void onBindViewHolder(@NonNull QuizViewHolder holder, int position) {
        int quizTitleColor;
        int quizCardColor;
        this.loadInterstitialAd();
        this.loadRewardedAdvertisement();
        final Quiz quiz = this.quizList.get(position);
        if (quiz.getColorCode() == 1) {
            quizCardColor = this.context.getResources().getColor(2131034750);
            quizTitleColor = this.context.getResources().getColor(2131034759);
        } else if (quiz.getColorCode() == 2) {
            quizCardColor = this.context.getResources().getColor(2131034751);
            quizTitleColor = this.context.getResources().getColor(2131034760);
        } else if (quiz.getColorCode() == 3) {
            quizCardColor = this.context.getResources().getColor(2131034752);
            quizTitleColor = this.context.getResources().getColor(2131034761);
        } else if (quiz.getColorCode() == 4) {
            quizCardColor = this.context.getResources().getColor(2131034753);
            quizTitleColor = this.context.getResources().getColor(2131034762);
        } else if (quiz.getColorCode() == 5) {
            quizCardColor = this.context.getResources().getColor(2131034754);
            quizTitleColor = this.context.getResources().getColor(2131034763);
        } else if (quiz.getColorCode() == 6) {
            quizCardColor = this.context.getResources().getColor(2131034755);
            quizTitleColor = this.context.getResources().getColor(2131034764);
        } else if (quiz.getColorCode() == 7) {
            quizCardColor = this.context.getResources().getColor(2131034756);
            quizTitleColor = this.context.getResources().getColor(2131034765);
        } else if (quiz.getColorCode() == 8) {
            quizCardColor = this.context.getResources().getColor(2131034757);
            quizTitleColor = this.context.getResources().getColor(2131034766);
        } else {
            quizCardColor = this.context.getResources().getColor(2131034758);
            quizTitleColor = this.context.getResources().getColor(2131034742);
            holder.quizCard.setCardElevation(2.0f);
        }
        holder.quizCard.setCardBackgroundColor(quizCardColor);
        holder.quizTitle.setText((CharSequence)quiz.getName());
        holder.quizTitle.setTextColor(quizTitleColor);
        if (quiz.getEntryFee() == 0) {
            holder.quizEntryFee.setText((CharSequence)this.context.getResources().getString(2131886202));
            holder.coinIcon.setVisibility(8);
        } else {
            holder.quizEntryFee.setText((CharSequence)String.valueOf(quiz.getEntryFee()));
        }
        if (!quiz.getIcon().trim().isEmpty()) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + quiz.getIcon()).into(holder.quizIcon);
        } else {
            holder.quizIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)2131165413));
        }
        holder.quizCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizAdapter.this.showQuizBottomSheet(quizTitleColor, quiz);
            }
        });
    }

    public int getItemCount() {
        return this.quizList.size();
    }

    void showQuizBottomSheet(int color2, final Quiz quiz) {
        this.quizBottomSheet = new BottomSheetDialog(this.context);
        View bottomSheetView = LayoutInflater.from((Context)this.context).inflate(2131493006, (ViewGroup)((ConstraintLayout)this.view.findViewById(2131296863)), false);
        this.quizBottomSheet.setContentView(bottomSheetView);
        this.quizBottomSheet.setOnShowListener(new DialogInterface.OnShowListener(){

            public void onShow(DialogInterface dialog) {
                BottomSheetDialog a = QuizAdapter.this.quizBottomSheet;
                FrameLayout bottomSheet = (FrameLayout)a.findViewById(2131296496);
                assert (bottomSheet != null);
                BottomSheetBehavior.from((View)bottomSheet).setState(3);
            }
        });
        TextView quizTitle = (TextView)this.quizBottomSheet.findViewById(2131296409);
        ImageView quizIcon = (ImageView)this.quizBottomSheet.findViewById(2131296407);
        TextView quizRulesTv = (TextView)this.quizBottomSheet.findViewById(2131296408);
        TextView entryFee = (TextView)this.quizBottomSheet.findViewById(2131296406);
        ImageView coinIcon = (ImageView)this.quizBottomSheet.findViewById(2131296405);
        this.playButton = (Button)this.quizBottomSheet.findViewById(2131296878);
        this.quizLoadingAnimation = (LottieAnimationView)this.quizBottomSheet.findViewById(2131296877);
        String quizRules = String.format(this.context.getResources().getString(2131886396), quiz.getQuestionLimit()) + '\n' + String.format(this.context.getResources().getString(2131886398), quiz.getLivesAvailable()) + '\n' + this.context.getResources().getString(2131886397) + '\n' + this.context.getResources().getString(2131886395) + '\n' + this.context.getResources().getString(2131886394);
        assert (quizTitle != null);
        quizTitle.setTextColor(color2);
        quizTitle.setText((CharSequence)quiz.getName());
        quizRulesTv.setText((CharSequence)quizRules);
        if (quiz.getEntryFee() == 0) {
            entryFee.setText((CharSequence)this.context.getResources().getString(2131886202));
            coinIcon.setVisibility(8);
        } else {
            entryFee.setText((CharSequence)String.valueOf(quiz.getEntryFee()));
        }
        if (!quiz.getIcon().trim().isEmpty()) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + quiz.getIcon()).into(quizIcon);
        } else {
            quizIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)2131165413));
        }
        this.playButton.setBackgroundColor(color2);
        this.playButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizAdapter.this.playQuiz(quiz);
            }
        });
        if (!this.activity.isFinishing()) {
            this.quizBottomSheet.show();
        }
    }

    public void playQuiz(final Quiz quiz) {
        if (quiz.getEntryFee() <= this.userCoins) {
            int paid = quiz.getEntryFee() != 0 ? 1 : 0;
            Call<ApiResponse> playQuizCall = ApiController.getInstance().getApi().playQuiz(FirebaseAuth.getInstance().getUid(), quiz.getIcon(), quiz.getName() + this.context.getResources().getString(2131886184), quiz.getEntryFee(), paid);
            playQuizCall.enqueue((Callback)new Callback<ApiResponse>(){

                public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                    if (((ApiResponse)response.body()).getStatusCode() == 0) {
                        QuizAdapter.this.showInterstitialAd(quiz);
                    } else {
                        QuizzeSnackBar.showSnackBar(QuizAdapter.this.context, QuizAdapter.this.view, QuizAdapter.this.context.getResources().getString(2131886224), QuizAdapter.this.context.getResources().getColor(2131034225));
                        Log.d((String)QuizAdapter.TAG, (String)((ApiResponse)response.body()).getMessage());
                    }
                }

                public void onFailure(Call<ApiResponse> call, Throwable t) {
                    QuizzeSnackBar.showSnackBar(QuizAdapter.this.context, QuizAdapter.this.view, QuizAdapter.this.context.getResources().getString(2131886416), QuizAdapter.this.context.getResources().getColor(2131034225));
                    Log.d((String)QuizAdapter.TAG, (String)("playQuizCall Failure = " + t.getLocalizedMessage()));
                }
            });
        } else {
            this.showNoCoinsBottomSheet();
        }
    }

    public void showNoCoinsBottomSheet() {
        if (this.quizBottomSheet.isShowing()) {
            this.quizBottomSheet.cancel();
        }
        this.noCoinsBottomSheet = new BottomSheetDialog(this.context);
        View noCoinsBottomSheetView = LayoutInflater.from((Context)this.context).inflate(2131492996, (ViewGroup)((ConstraintLayout)this.view.findViewById(2131296782)), false);
        this.noCoinsBottomSheet.setContentView(noCoinsBottomSheetView);
        this.watchAdBtn = (MaterialCardView)noCoinsBottomSheetView.findViewById(2131297132);
        TextView noCoinsSubText = (TextView)noCoinsBottomSheetView.findViewById(2131296783);
        TextView watchAdBtnTitle = (TextView)noCoinsBottomSheetView.findViewById(2131297133);
        this.loadingAnimationAd = (LottieAnimationView)noCoinsBottomSheetView.findViewById(2131296686);
        String noCoinsDesc = this.context.getString(2131886437) + " +" + this.watchEarnReward;
        noCoinsSubText.setText((CharSequence)noCoinsDesc);
        String watchAdTitle = this.context.getResources().getString(2131886435) + " +" + this.watchEarnReward + ' ' + this.context.getResources().getString(2131886140);
        watchAdBtnTitle.setText((CharSequence)watchAdTitle);
        this.watchAdBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizAdapter.this.loadingAnimationAd.setVisibility(0);
                QuizAdapter.this.watchAdBtn.setVisibility(8);
                QuizAdapter.this.showRewardedAd();
            }
        });
        if (!this.activity.isFinishing()) {
            this.noCoinsBottomSheet.show();
        }
    }

    public void showRewardedAd() {
        if (this.adEnabled == 1) {
            if (this.mRewardedAd != null) {
                this.mRewardedAd.show(this.activity, new OnUserEarnedRewardListener(){

                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        QuizAdapter.this.getAdReward();
                        QuizAdapter.this.activity.startActivity(new Intent(QuizAdapter.this.context, MainActivity.class));
                        QuizAdapter.this.activity.finish();
                    }
                });
            } else if (this.loadingAnimationAd != null && this.watchAdBtn != null) {
                this.loadingAnimationAd.setVisibility(8);
                this.watchAdBtn.setVisibility(0);
                QuizzeSnackBar.showSnackBar(this.context, this.view, this.context.getResources().getString(2131886348), this.context.getResources().getColor(2131034225));
            }
        } else if (this.loadingAnimationAd != null && this.watchAdBtn != null) {
            this.loadingAnimationAd.setVisibility(8);
            this.watchAdBtn.setVisibility(0);
            QuizzeSnackBar.showSnackBar(this.context, this.view, this.context.getResources().getString(2131886348), this.context.getResources().getColor(2131034225));
        }
    }

    public void loadRewardedAdvertisement() {
        AdRequest adRequest = new AdRequest.Builder().build();
        RewardedAd.load((Context)this.context, (String)this.rewardedAdId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                Log.d((String)QuizAdapter.TAG, (String)("Failed to load interstitial ad = " + loadAdError));
                QuizAdapter.this.mRewardedAd = null;
            }

            public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                super.onAdLoaded((Object)rewardedAd);
                QuizAdapter.this.mRewardedAd = rewardedAd;
            }
        });
    }

    public void showInterstitialAd(final Quiz quiz) {
        if (this.playButton != null && this.quizLoadingAnimation != null) {
            this.playButton.setVisibility(8);
            this.quizLoadingAnimation.setVisibility(0);
        }
        if (this.adEnabled == 1) {
            if (this.mInterstitialAd != null) {
                this.mInterstitialAd.show(this.activity);
                this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                    public void onAdDismissedFullScreenContent() {
                        super.onAdDismissedFullScreenContent();
                        QuizAdapter.this.starQuiz(quiz);
                    }
                });
            } else {
                this.starQuiz(quiz);
            }
        } else {
            this.starQuiz(quiz);
            this.mInterstitialAd = null;
        }
    }

    public void getAdReward() {
        if (this.noCoinsBottomSheet.isShowing()) {
            this.noCoinsBottomSheet.cancel();
        }
        Call<ApiResponse> getAdRewardCall = ApiController.getInstance().getApi().getAdCoins(FirebaseAuth.getInstance().getUid(), this.watchEarnReward, this.context.getResources().getString(2131886438), 0);
        getAdRewardCall.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (((ApiResponse)response.body()).statusCode == 0) {
                    QuizzeSnackBar.showSnackBar(QuizAdapter.this.context, QuizAdapter.this.view, "User Earned Reward", QuizAdapter.this.context.getResources().getColor(2131034780));
                } else {
                    QuizzeSnackBar.showSnackBar(QuizAdapter.this.context, QuizAdapter.this.view, QuizAdapter.this.context.getResources().getString(2131886224), QuizAdapter.this.context.getResources().getColor(2131034225));
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                Log.d((String)QuizAdapter.TAG, (String)("getAdRewardCall Failure = " + t.getLocalizedMessage()));
                QuizzeSnackBar.showSnackBar(QuizAdapter.this.context, QuizAdapter.this.view, QuizAdapter.this.context.getResources().getString(2131886416), QuizAdapter.this.context.getResources().getColor(2131034225));
            }
        });
    }

    public void starQuiz(Quiz quiz) {
        if (this.quizBottomSheet.isShowing()) {
            this.quizBottomSheet.cancel();
        }
        Intent intent = new Intent(this.context, QuizScreen.class);
        intent.putExtra("quizId", quiz.getId());
        intent.putExtra("quizName", quiz.getName());
        intent.putExtra("quizIcon", quiz.getIcon());
        intent.putExtra("quizEntryFee", quiz.getEntryFee());
        intent.putExtra("quizColorCode", quiz.getColorCode());
        intent.putExtra("quizDifficultyEasy", quiz.getEasy());
        intent.putExtra("quizDifficultyMedium", quiz.getMedium());
        intent.putExtra("quizDifficultyHard", quiz.getHard());
        intent.putExtra("quizQuestionLimit", quiz.getQuestionLimit());
        intent.putExtra("quizLivesAvailable", quiz.getLivesAvailable());
        intent.putExtra("quizTimeAvailable", quiz.getTime());
        intent.putExtra("quizPrizePerQuestion", quiz.getPrizePerQuestion());
        intent.putExtra("adEnabled", this.adEnabled);
        intent.putExtra("nativeAdId", this.nativeAdId);
        intent.putExtra("interstitialAdId", this.interstitialAdId);
        intent.putExtra("rewardedAdId", this.rewardedAdId);
        this.context.startActivity(intent);
    }

    public void loadInterstitialAd() {
        AdRequest adRequest = new AdRequest.Builder().build();
        InterstitialAd.load((Context)this.context, (String)this.interstitialAdId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                Log.d((String)QuizAdapter.TAG, (String)"Failed to load interstitial ad");
            }

            public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                super.onAdLoaded((Object)interstitialAd);
                QuizAdapter.this.mInterstitialAd = interstitialAd;
            }
        });
    }

    public class QuizViewHolder
    extends RecyclerView.ViewHolder {
        MaterialCardView quizCard;
        TextView quizTitle;
        TextView quizEntryFee;
        ImageView quizIcon;
        ImageView coinIcon;

        public QuizViewHolder(View itemView) {
            super(itemView);
            this.quizCard = (MaterialCardView)itemView.findViewById(2131296864);
            this.quizTitle = (TextView)itemView.findViewById(2131296883);
            this.quizEntryFee = (TextView)itemView.findViewById(2131296865);
            this.quizIcon = (ImageView)itemView.findViewById(2131296875);
            this.coinIcon = (ImageView)itemView.findViewById(2131296456);
        }
    }
}

