/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.models.PlayingHistory;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.squareup.picasso.Picasso;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class PlayingHistoryAdapter
extends RecyclerView.Adapter<PlayingHistoryViewHolder> {
    private Context context;
    private Activity activity;
    private List<PlayingHistory> playingHistoryList;
    private int adEnabled;
    private String nativeAdId;
    public final String TAG = "PLAYING_HISTORY_ADAPTER";

    public PlayingHistoryAdapter(Context context, Activity activity, List<PlayingHistory> playingHistoryList, int adEnabled, String nativeAdId) {
        this.context = context;
        this.activity = activity;
        this.playingHistoryList = playingHistoryList;
        this.adEnabled = adEnabled;
        this.nativeAdId = nativeAdId;
    }

    @NonNull
    public PlayingHistoryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new PlayingHistoryViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131493005, parent, false));
    }

    public void onBindViewHolder(@NonNull PlayingHistoryViewHolder holder, int position) {
        PlayingHistory playingHistory = this.playingHistoryList.get(position);
        if (!playingHistory.getIcon().trim().equals("")) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + playingHistory.getIcon()).into(holder.playingHistoryIcon);
        } else {
            Drawable playingHistoryIcon = playingHistory.getType().equals("INVITE BONUS") ? ContextCompat.getDrawable((Context)this.context, (int)2131165414) : (playingHistory.getType().equals("INVITE JOIN EARN") ? ContextCompat.getDrawable((Context)this.context, (int)2131165416) : (playingHistory.getType().equals("DAIlY CHECK IN") ? ContextCompat.getDrawable((Context)this.context, (int)2131165330) : (playingHistory.getType().equals("AD REWARD") ? ContextCompat.getDrawable((Context)this.context, (int)2131165308) : (playingHistory.getType().equals("WITHDRAW") ? ContextCompat.getDrawable((Context)this.context, (int)2131165412) : ContextCompat.getDrawable((Context)this.context, (int)2131165331)))));
            holder.playingHistoryIcon.setImageDrawable(playingHistoryIcon);
        }
        holder.playingActivity.setText((CharSequence)playingHistory.getActivity());
        int isPaid = playingHistory.getPaid() == 1 ? this.context.getResources().getColor(2131034225) : this.context.getResources().getColor(2131034780);
        char coinSign = playingHistory.getPaid() == 1 ? (char)'-' : '+';
        holder.playingCoins.setText((CharSequence)(coinSign + String.valueOf(playingHistory.getCoins())));
        holder.playingCoins.setTextColor(isPaid);
        Date date = new Date(Long.parseLong(playingHistory.getDate()) * 1000L);
        String formattedDate = new SimpleDateFormat("d MMM yyyy, hh:mm aaa", Locale.getDefault()).format(date);
        holder.playingTime.setText((CharSequence)formattedDate);
        int p = holder.getAdapterPosition() % 5;
        if (p <= 0) {
            holder.adLayout.setVisibility(0);
            this.loadNativeAd(this.nativeAdId, holder.adLayout);
        } else {
            holder.adLayout.setVisibility(8);
        }
    }

    public int getItemCount() {
        return this.playingHistoryList.size();
    }

    public void populateNativeAd(NativeAd nativeAd, NativeAdView nativeAdView) {
        nativeAdView.setIconView(nativeAdView.findViewById(2131296347));
        nativeAdView.setHeadlineView(nativeAdView.findViewById(2131296344));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(2131296338));
        nativeAdView.setBodyView(nativeAdView.findViewById(2131296337));
        if (nativeAd != null) {
            ((TextView)nativeAdView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
            if (nativeAd.getIcon() == null) {
                nativeAdView.getIconView().setVisibility(4);
            } else {
                nativeAdView.getIconView().setVisibility(0);
                ((ImageView)nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            }
            if (nativeAd.getBody() == null) {
                nativeAdView.getBodyView().setVisibility(4);
            } else {
                nativeAdView.getBodyView().setVisibility(0);
                ((TextView)nativeAdView.getBodyView()).setText((CharSequence)nativeAd.getBody());
            }
            if (nativeAd.getCallToAction() == null) {
                nativeAdView.getCallToActionView().setVisibility(4);
            } else {
                nativeAdView.getCallToActionView().setVisibility(0);
                ((Button)nativeAdView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
            }
            nativeAdView.setNativeAd(nativeAd);
        }
    }

    private void loadNativeAd(String nativeAdId, final FrameLayout frameLayout) {
        if (this.adEnabled == 1) {
            AdLoader.Builder builder = new AdLoader.Builder(this.context, nativeAdId);
            builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

                public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
                    NativeAdView nativeAdView = (NativeAdView)PlayingHistoryAdapter.this.activity.getLayoutInflater().inflate(2131493014, null);
                    if (nativeAdView == null) {
                        Log.d((String)"PLAYING_HISTORY_ADAPTER", (String)"NATIVE AD VIEW IS NULL");
                    }
                    PlayingHistoryAdapter.this.populateNativeAd(nativeAd, nativeAdView);
                    frameLayout.removeAllViews();
                    frameLayout.addView((View)nativeAdView);
                }
            });
            AdLoader adLoader = builder.withAdListener(new AdListener(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)"PLAYING_HISTORY_ADAPTER", (String)("Failed to load interstitital ad = " + loadAdError));
                }
            }).build();
            adLoader.loadAd(new AdRequest.Builder().build());
        }
    }

    public static class PlayingHistoryViewHolder
    extends RecyclerView.ViewHolder {
        ImageView playingHistoryIcon;
        TextView playingActivity;
        TextView playingTime;
        TextView playingCoins;
        FrameLayout adLayout;

        public PlayingHistoryViewHolder(@NonNull View itemView) {
            super(itemView);
            this.playingHistoryIcon = (ImageView)itemView.findViewById(2131296837);
            this.playingActivity = (TextView)itemView.findViewById(2131296834);
            this.playingTime = (TextView)itemView.findViewById(2131296839);
            this.playingCoins = (TextView)itemView.findViewById(2131296835);
            this.adLayout = (FrameLayout)itemView.findViewById(2131296944);
        }
    }
}

