/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.models.Invitee;
import com.squareup.picasso.Picasso;
import java.util.List;

public class InviteeAdapter
extends RecyclerView.Adapter<InviteeViewHolder> {
    private final Context context;
    private final List<Invitee> inviteeList;
    private final int inviteeJoinReward;

    public InviteeAdapter(Context context, List<Invitee> inviteeList, int inviteeJoinReward) {
        this.context = context;
        this.inviteeList = inviteeList;
        this.inviteeJoinReward = inviteeJoinReward;
    }

    @NonNull
    public InviteeViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new InviteeViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131493019, parent, false));
    }

    public void onBindViewHolder(@NonNull InviteeViewHolder holder, int position) {
        Invitee invitee = this.inviteeList.get(position);
        if (invitee.getAvatar().trim().equals("")) {
            holder.inviteeAvatar.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)2131165413));
        } else {
            Picasso.get().load("https://gaou.biogenesis.fr/" + invitee.getAvatar()).into(holder.inviteeAvatar);
        }
        holder.inviteeName.setText((CharSequence)invitee.getName());
        String inviteeEmail = invitee.getEmail().substring(0, 4) + "*****";
        holder.inviteeEmail.setText((CharSequence)inviteeEmail);
        String inviteeJoinBonus = "+" + this.inviteeJoinReward;
        holder.inviteeBonus.setText((CharSequence)inviteeJoinBonus);
    }

    public int getItemCount() {
        if (this.inviteeList != null) {
            return this.inviteeList.size();
        }
        return 0;
    }

    public static class InviteeViewHolder
    extends RecyclerView.ViewHolder {
        ImageView inviteeAvatar;
        TextView inviteeName;
        TextView inviteeEmail;
        TextView inviteeBonus;

        public InviteeViewHolder(@NonNull View itemView) {
            super(itemView);
            this.inviteeAvatar = (ImageView)itemView.findViewById(2131296648);
            this.inviteeName = (TextView)itemView.findViewById(2131296651);
            this.inviteeEmail = (TextView)itemView.findViewById(2131296650);
            this.inviteeBonus = (TextView)itemView.findViewById(2131296649);
        }
    }
}

