/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.content.Intent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.AllQuizActivity;
import com.ElyStudio.leGaou.models.Category;
import com.google.android.material.card.MaterialCardView;
import com.squareup.picasso.Picasso;
import java.util.List;

public class CategoryAdapter
extends RecyclerView.Adapter<CategoryViewHolder> {
    private Context context;
    private List<Category> categoryList;
    private int adEnabled;
    private int userCoins;
    private int watchEarnReward;
    private String nativeAdId;
    private String interstitialAdId;
    private String rewardedAdId;

    public CategoryAdapter(Context context, List<Category> categoryList, int adEnabled, int userCoins, int watchEarnReward, String nativeAdId, String interstitialAdId, String rewardedAdId) {
        this.context = context;
        this.categoryList = categoryList;
        this.adEnabled = adEnabled;
        this.userCoins = userCoins;
        this.watchEarnReward = watchEarnReward;
        this.nativeAdId = nativeAdId;
        this.interstitialAdId = interstitialAdId;
        this.rewardedAdId = rewardedAdId;
    }

    @NonNull
    public CategoryViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new CategoryViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131492916, parent, false));
    }

    public void onBindViewHolder(@NonNull CategoryViewHolder holder, int position) {
        final Category category = this.categoryList.get(position);
        int colorCode = category.getColorCode();
        int categoryCardColor = colorCode == 1 ? this.context.getResources().getColor(2131034750) : (colorCode == 2 ? this.context.getResources().getColor(2131034751) : (colorCode == 3 ? this.context.getResources().getColor(2131034752) : (colorCode == 4 ? this.context.getResources().getColor(2131034753) : (colorCode == 5 ? this.context.getResources().getColor(2131034754) : (colorCode == 6 ? this.context.getResources().getColor(2131034755) : (colorCode == 7 ? this.context.getResources().getColor(2131034756) : (colorCode == 8 ? this.context.getResources().getColor(2131034757) : this.context.getResources().getColor(2131034758))))))));
        holder.categoryCard.setCardBackgroundColor(categoryCardColor);
        if (!category.getIcon().trim().isEmpty()) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + category.getIcon()).into(holder.categoryIcon);
        } else {
            holder.categoryIcon.setImageDrawable(ContextCompat.getDrawable((Context)this.context, (int)2131165413));
        }
        holder.categoryCard.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                Intent intent = new Intent(CategoryAdapter.this.context, AllQuizActivity.class);
                intent.putExtra("categoryId", category.getId());
                intent.putExtra("categoryTitle", category.getName());
                intent.putExtra("adEnabled", CategoryAdapter.this.adEnabled);
                intent.putExtra("watchEarnReward", CategoryAdapter.this.watchEarnReward);
                intent.putExtra("nativeAdId", CategoryAdapter.this.nativeAdId);
                intent.putExtra("interstitialAdId", CategoryAdapter.this.interstitialAdId);
                intent.putExtra("rewardedAdId", CategoryAdapter.this.rewardedAdId);
                CategoryAdapter.this.context.startActivity(intent);
            }
        });
    }

    public int getItemCount() {
        return this.categoryList.size();
    }

    public class CategoryViewHolder
    extends RecyclerView.ViewHolder {
        MaterialCardView categoryCard;
        ImageView categoryIcon;

        public CategoryViewHolder(View itemView) {
            super(itemView);
            this.categoryCard = (MaterialCardView)itemView.findViewById(2131296432);
            this.categoryIcon = (ImageView)itemView.findViewById(2131296433);
        }
    }
}

