/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.models.Avatars;
import com.ElyStudio.leGaou.utilities.OnItemClick;
import com.google.android.material.card.MaterialCardView;
import com.squareup.picasso.Picasso;
import java.util.List;

public class AvatarAdapter
extends RecyclerView.Adapter<AvatarViewHolder> {
    private final List<Avatars> avatarsList;
    int selectedIndex = 0;
    private final OnItemClick mCallBack;

    public AvatarAdapter(List<Avatars> avatarsList, OnItemClick mCallBack) {
        this.avatarsList = avatarsList;
        this.mCallBack = mCallBack;
    }

    @NonNull
    public AvatarViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AvatarViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131492912, parent, false));
    }

    public void onBindViewHolder(@NonNull AvatarViewHolder holder, int position) {
        String avatarImage = this.avatarsList.get(position).getImage();
        if (holder.getAdapterPosition() == this.selectedIndex) {
            this.mCallBack.onClick(avatarImage);
            holder.avatarCard.setStrokeWidth(8);
        } else {
            holder.avatarCard.setStrokeWidth(0);
        }
        if (avatarImage != null && !avatarImage.equals("")) {
            Picasso.get().load("https://gaou.biogenesis.fr/" + avatarImage).into(holder.avatarImage);
        }
        holder.avatarCard.setOnClickListener(v -> {
            this.selectedIndex = holder.getAdapterPosition();
            this.mCallBack.onClick(avatarImage);
            this.notifyDataSetChanged();
        });
    }

    public int getItemCount() {
        return this.avatarsList.size();
    }

    public static class AvatarViewHolder
    extends RecyclerView.ViewHolder {
        MaterialCardView avatarCard;
        ImageView avatarImage;

        public AvatarViewHolder(@NonNull View itemView) {
            super(itemView);
            this.avatarCard = (MaterialCardView)itemView.findViewById(2131296388);
            this.avatarImage = (ImageView)itemView.findViewById(2131296389);
        }
    }
}

