/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.adapter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.models.AppLanguage;
import com.ElyStudio.leGaou.utilities.LanguageManager;
import com.google.android.material.card.MaterialCardView;
import java.util.List;

public class AppLanguageAdapter
extends RecyclerView.Adapter<AppLanguageViewHolder> {
    private final Context context;
    private final Activity activity;
    private final List<AppLanguage> appLanguageList;
    SharedPreferences sharedPreferences;

    public AppLanguageAdapter(Context context, Activity activity, List<AppLanguage> appLanguageList) {
        this.context = context;
        this.activity = activity;
        this.appLanguageList = appLanguageList;
    }

    @NonNull
    public AppLanguageViewHolder onCreateViewHolder(@NonNull ViewGroup parent, int viewType) {
        return new AppLanguageViewHolder(LayoutInflater.from((Context)parent.getContext()).inflate(2131492941, parent, false));
    }

    public void onBindViewHolder(@NonNull AppLanguageViewHolder holder, int position) {
        this.sharedPreferences = this.activity.getSharedPreferences("APP_PREFERENCES", 0);
        String selectedLanguage = this.sharedPreferences.getString("appLanguage", "fr");
        LanguageManager languageManager = new LanguageManager(this.context);
        AppLanguage language = this.appLanguageList.get(position);
        holder.languageName.setText((CharSequence)language.getLanguageName());
        if (language.getLanguageCode().equals(selectedLanguage)) {
            holder.languageName.setTextColor(this.context.getResources().getColor(2131034797));
            holder.appLanguageCard.setCardBackgroundColor(this.context.getResources().getColor(2131034732));
            holder.selectedLanguageIcon.setVisibility(0);
        }
        holder.appLanguageCard.setOnClickListener(v -> {
            languageManager.updateLanguage(language.getLanguageCode());
            this.activity.startActivity(new Intent((Context)this.activity, MainActivity.class));
            this.activity.finish();
        });
    }

    public int getItemCount() {
        return this.appLanguageList.size();
    }

    public static class AppLanguageViewHolder
    extends RecyclerView.ViewHolder {
        MaterialCardView appLanguageCard;
        TextView languageName;
        ImageView selectedLanguageIcon;

        public AppLanguageViewHolder(@NonNull View itemView) {
            super(itemView);
            this.languageName = (TextView)itemView.findViewById(2131296660);
            this.appLanguageCard = (MaterialCardView)itemView.findViewById(2131296659);
            this.selectedLanguageIcon = (ImageView)itemView.findViewById(2131296661);
        }
    }
}

