/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.WithdrawMethodAdapter;
import com.ElyStudio.leGaou.databinding.ActivityWalletScreenBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.GetWalletData;
import com.ElyStudio.leGaou.models.WithdrawMethods;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.OnWithdrawMethodSelect;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class WalletScreen
extends AppCompat
implements OnWithdrawMethodSelect {
    ActivityWalletScreenBinding binding;
    String selectedWithdrawMethod;
    String withdrawMethodIdName;
    String withdrawMethodIcon;
    BottomSheetDialog withdrawBottomSheet;
    int userCoins;
    int minimumWithdrawLimit;
    int conversionRate;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;
    public static final String TAG = "WALLET_SCREEN";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityWalletScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.withdrawBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (WalletScreen.this.selectedWithdrawMethod != null && !WalletScreen.this.selectedWithdrawMethod.trim().equals("")) {
                    if (WalletScreen.this.userCoins >= WalletScreen.this.minimumWithdrawLimit) {
                        WalletScreen.this.showWithdrawBottomSheet();
                    } else {
                        QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, (View)WalletScreen.this.binding.getRoot(), WalletScreen.this.getResources().getString(2131886357), WalletScreen.this.getResources().getColor(2131034225));
                    }
                } else {
                    QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, (View)WalletScreen.this.binding.getRoot(), WalletScreen.this.getResources().getString(2131886178), WalletScreen.this.getResources().getColor(2131034225));
                }
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.getWalletData();
    }

    private void getWalletData() {
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<GetWalletData> getWalletDataCall = ApiController.getInstance().getApi().getWalletData(FirebaseAuth.getInstance().getUid());
            getWalletDataCall.enqueue((Callback)new Callback<GetWalletData>(){

                public void onResponse(Call<GetWalletData> call, Response<GetWalletData> response) {
                    if (((GetWalletData)response.body()).getStatusCode() == 0) {
                        WalletScreen.this.binding.userCoins.setText((CharSequence)String.valueOf(((GetWalletData)response.body()).getCoins()));
                        WalletScreen.this.userCoins = ((GetWalletData)response.body()).getCoins();
                        WalletScreen.this.conversionRate = ((GetWalletData)response.body()).getConversionRate();
                        WalletScreen.this.minimumWithdrawLimit = ((GetWalletData)response.body()).getMinimumWithdrawLimit();
                        float conversion = (float)((GetWalletData)response.body()).getCoins() / (float)((GetWalletData)response.body()).getConversionRate();
                        WalletScreen.this.binding.coinConversion.setText((CharSequence)(conversion + WalletScreen.this.getResources().getString(2131886173)));
                        int maxWithdrawTime = ((GetWalletData)response.body()).getMaximumWithdrawTime();
                        WalletScreen.this.binding.withdrawRules.setText((CharSequence)String.format(WalletScreen.this.getResources().getString(2131886445), maxWithdrawTime));
                        WalletScreen.this.binding.minimumWithdrawLimit.setText((CharSequence)String.format(WalletScreen.this.getResources().getString(2131886277), ((GetWalletData)response.body()).getMinimumWithdrawLimit()));
                        if (((GetWalletData)response.body()).getWithdrawMethodsList() != null) {
                            WalletScreen.this.setWithdrawMethodRecyclerView(((GetWalletData)response.body()).getWithdrawMethodsList());
                        }
                    } else {
                        WalletScreen.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<GetWalletData> call, Throwable t) {
                    Log.d((String)WalletScreen.TAG, (String)("getWalletDataCall Failure = " + t.getLocalizedMessage()));
                    WalletScreen.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    public void setWithdrawMethodRecyclerView(List<WithdrawMethods> withdrawMethodsList) {
        WithdrawMethodAdapter adapter = new WithdrawMethodAdapter(withdrawMethodsList, (Context)this, this);
        LinearLayoutManager layoutManager = new LinearLayoutManager((Context)this, 0, false);
        this.binding.withdrawMethodsRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        this.binding.withdrawMethodsRecyclerView.setAdapter((RecyclerView.Adapter)adapter);
    }

    @Override
    public void onMethodSelected(String name, String idName, String icon) {
        this.selectedWithdrawMethod = name;
        this.withdrawMethodIdName = idName;
        this.withdrawMethodIcon = icon;
    }

    public void showWithdrawBottomSheet() {
        this.withdrawBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131493020, (ViewGroup)this.findViewById(2131297139), false);
        this.withdrawBottomSheet.setContentView(view);
        final EditText withdrawMethodEdittext = (EditText)this.withdrawBottomSheet.findViewById(2131297144);
        final EditText coinsEditText = (EditText)this.withdrawBottomSheet.findViewById(2131296458);
        final LinearLayout withdrawInputLayout = (LinearLayout)this.withdrawBottomSheet.findViewById(2131297142);
        final LinearLayout successfulLayout = (LinearLayout)this.withdrawBottomSheet.findViewById(2131296975);
        Button withdrawCoinsBtn = (Button)this.withdrawBottomSheet.findViewById(2131297141);
        Button thanksBtn = (Button)this.withdrawBottomSheet.findViewById(2131297061);
        withdrawMethodEdittext.setHint((CharSequence)this.withdrawMethodIdName);
        withdrawCoinsBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                int coinsInput = Integer.parseInt(coinsEditText.getText().toString().trim());
                String methodId = withdrawMethodEdittext.getText().toString().trim();
                if (!coinsEditText.getText().toString().isEmpty() && !methodId.isEmpty()) {
                    if (coinsInput <= WalletScreen.this.userCoins) {
                        if (coinsInput >= WalletScreen.this.minimumWithdrawLimit) {
                            float amount = (float)coinsInput / (float)WalletScreen.this.conversionRate;
                            Call<ApiResponse> createWithdrawRequestCall = ApiController.getInstance().getApi().createWithdrawRequest(FirebaseAuth.getInstance().getUid(), WalletScreen.this.selectedWithdrawMethod, methodId, WalletScreen.this.withdrawMethodIcon, coinsInput, amount, String.format(WalletScreen.this.getResources().getString(2131886440), WalletScreen.this.selectedWithdrawMethod));
                            createWithdrawRequestCall.enqueue((Callback)new Callback<ApiResponse>(){

                                public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                                    if (((ApiResponse)response.body()).getStatusCode() == 0) {
                                        withdrawInputLayout.setVisibility(8);
                                        successfulLayout.setVisibility(0);
                                    } else {
                                        WalletScreen.this.withdrawBottomSheet.cancel();
                                        QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, (View)WalletScreen.this.binding.getRoot(), WalletScreen.this.getResources().getString(2131886224), WalletScreen.this.getResources().getColor(2131034225));
                                    }
                                }

                                public void onFailure(Call<ApiResponse> call, Throwable t) {
                                    Log.d((String)WalletScreen.TAG, (String)("createWithdrawRequestCall Failure = " + t.getLocalizedMessage()));
                                    WalletScreen.this.withdrawBottomSheet.cancel();
                                    QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, (View)WalletScreen.this.binding.getRoot(), WalletScreen.this.getResources().getString(2131886416), WalletScreen.this.getResources().getColor(2131034225));
                                }
                            });
                        } else {
                            QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, view, WalletScreen.this.getResources().getString(2131886442), WalletScreen.this.getResources().getColor(2131034225));
                        }
                    } else {
                        QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, view, WalletScreen.this.getResources().getString(2131886357), WalletScreen.this.getResources().getColor(2131034225));
                    }
                } else if (methodId.isEmpty()) {
                    QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, view, String.format(WalletScreen.this.getResources().getString(2131886441), WalletScreen.this.withdrawMethodIdName), WalletScreen.this.getResources().getColor(2131034225));
                } else if (coinsEditText.getText().toString().trim().isEmpty()) {
                    QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, view, WalletScreen.this.getResources().getString(2131886176), WalletScreen.this.getResources().getColor(2131034225));
                } else {
                    QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, view, WalletScreen.this.getResources().getString(2131886177), WalletScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        thanksBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WalletScreen.this.withdrawBottomSheet.cancel();
                WalletScreen.this.getWalletData();
            }
        });
        if (!this.isFinishing()) {
            this.withdrawBottomSheet.show();
        }
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)WalletScreen.this)) {
                    WalletScreen.this.noInternetBottomSheet.cancel();
                    WalletScreen.this.getWalletData();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)WalletScreen.this, view, WalletScreen.this.getResources().getString(2131886351), WalletScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WalletScreen.this.startActivity(new Intent((Context)WalletScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                WalletScreen.this.errorOccurredBottomSheet.cancel();
                WalletScreen.this.getWalletData();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

