/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.GridLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.activities.UserProfileScreen;
import com.ElyStudio.leGaou.adapter.AvatarAdapter;
import com.ElyStudio.leGaou.databinding.ActivityUpdateAvatarBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.Avatars;
import com.ElyStudio.leGaou.models.QuizzeAvatars;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.OnItemClick;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class UpdateAvatarActivity
extends AppCompat
implements OnItemClick {
    ActivityUpdateAvatarBinding binding;
    String selectedAvatar;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;
    public static final String TAG = "UPDATE_AVATAR_ACTIVITY";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityUpdateAvatarBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.updateAvtarBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (UpdateAvatarActivity.this.selectedAvatar.trim().isEmpty()) {
                    QuizzeSnackBar.showSnackBar((Context)UpdateAvatarActivity.this, (View)UpdateAvatarActivity.this.binding.getRoot(), UpdateAvatarActivity.this.getResources().getString(2131886411), UpdateAvatarActivity.this.getResources().getColor(2131034225));
                } else {
                    UpdateAvatarActivity.this.updateAvatars();
                }
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.getAvatars();
    }

    private void getAvatars() {
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<QuizzeAvatars> getAvatarsCall = ApiController.getInstance().getApi().getAvatars();
            getAvatarsCall.enqueue((Callback)new Callback<QuizzeAvatars>(){

                public void onResponse(Call<QuizzeAvatars> call, Response<QuizzeAvatars> response) {
                    if (((QuizzeAvatars)response.body()).getstatusCode() == 0) {
                        if (((QuizzeAvatars)response.body()).avatarsList != null) {
                            UpdateAvatarActivity.this.setAvatarRecyclerView(((QuizzeAvatars)response.body()).avatarsList);
                        }
                    } else {
                        UpdateAvatarActivity.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<QuizzeAvatars> call, Throwable t) {
                    Log.d((String)UpdateAvatarActivity.TAG, (String)("getAvatarsCall Failure = " + t.getLocalizedMessage()));
                    UpdateAvatarActivity.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    @Override
    public void onClick(String value) {
        this.selectedAvatar = value;
    }

    private void setAvatarRecyclerView(List<Avatars> avatarsList) {
        this.binding.updateAvatarsRecyclerview.setLayoutManager((RecyclerView.LayoutManager)new GridLayoutManager((Context)this, 2, 1, false));
        this.binding.updateAvatarsRecyclerview.setAdapter((RecyclerView.Adapter)new AvatarAdapter(avatarsList, this));
    }

    private void updateAvatars() {
        Call<ApiResponse> updateAvatarCall = ApiController.getInstance().getApi().updateAvatar(FirebaseAuth.getInstance().getUid(), this.selectedAvatar);
        updateAvatarCall.enqueue((Callback)new Callback<ApiResponse>(){

            public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                if (((ApiResponse)response.body()).getStatusCode() == 0) {
                    QuizzeSnackBar.showSnackBar((Context)UpdateAvatarActivity.this, (View)UpdateAvatarActivity.this.binding.getRoot(), UpdateAvatarActivity.this.getResources().getString(2131886116), UpdateAvatarActivity.this.getResources().getColor(2131034780));
                    UpdateAvatarActivity.this.startActivity(new Intent((Context)UpdateAvatarActivity.this, UserProfileScreen.class));
                    UpdateAvatarActivity.this.finish();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)UpdateAvatarActivity.this, (View)UpdateAvatarActivity.this.binding.getRoot(), UpdateAvatarActivity.this.getResources().getString(2131886224), UpdateAvatarActivity.this.getResources().getColor(2131034225));
                }
            }

            public void onFailure(Call<ApiResponse> call, Throwable t) {
                Log.d((String)UpdateAvatarActivity.TAG, (String)("updateAvatarCall Failure = " + t.getLocalizedMessage()));
                QuizzeSnackBar.showSnackBar((Context)UpdateAvatarActivity.this, (View)UpdateAvatarActivity.this.binding.getRoot(), UpdateAvatarActivity.this.getResources().getString(2131886416), UpdateAvatarActivity.this.getResources().getColor(2131034225));
            }
        });
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)UpdateAvatarActivity.this)) {
                    UpdateAvatarActivity.this.noInternetBottomSheet.cancel();
                    UpdateAvatarActivity.this.getAvatars();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)UpdateAvatarActivity.this, view, UpdateAvatarActivity.this.getResources().getString(2131886351), UpdateAvatarActivity.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UpdateAvatarActivity.this.startActivity(new Intent((Context)UpdateAvatarActivity.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                UpdateAvatarActivity.this.errorOccurredBottomSheet.cancel();
                UpdateAvatarActivity.this.getAvatars();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

