/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.media.MediaPlayer;
import android.os.Build;
import android.os.Bundle;
import android.os.CountDownTimer;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import com.ElyStudio.leGaou.activities.LoseActivity;
import com.ElyStudio.leGaou.activities.QuizResultScreen;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.databinding.ActivityQuizScreenBinding;
import com.ElyStudio.leGaou.models.GetQuestions;
import com.ElyStudio.leGaou.models.Question;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.airbnb.lottie.LottieAnimationView;
import com.google.android.gms.ads.AdListener;
import com.google.android.gms.ads.AdLoader;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.interstitial.InterstitialAd;
import com.google.android.gms.ads.interstitial.InterstitialAdLoadCallback;
import com.google.android.gms.ads.nativead.NativeAd;
import com.google.android.gms.ads.nativead.NativeAdView;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.card.MaterialCardView;
import com.squareup.picasso.Picasso;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class QuizScreen
extends AppCompat {
    ActivityQuizScreenBinding binding;
    String difficulty = "";
    BottomSheetDialog difficultySelectionBottomSheet;
    BottomSheetDialog noLivesBottomSheet;
    public static final String TAG = "QUIZ_SCREEN";
    private Question question;
    List<Question> questionList;
    MediaPlayer quizBgMusic;
    MediaPlayer correctAnswerMusic;
    MediaPlayer wrongAnswerMusic;
    CountDownTimer quizTimer;
    int easy;
    int medium;
    int hard;
    int quizId;
    int questionLimit;
    int livesAvailable;
    int time;
    String quizName;
    String quizIcon;
    int adEnabled;
    String nativeAdId;
    String interstitialAdId;
    String rewardedAdId;
    int currentIndex = 0;
    int questionAttempted = 0;
    int score = 0;
    int quizColor;
    int quizEntryFee;
    int correctAnswers = 0;
    int wrongAnswers = 0;
    int leavedQuestions = 0;
    float prizePerQuestion;
    int index = 0;
    long millisSecondLeft;
    private InterstitialAd mInterstitialAd;
    private RewardedAd mRewardedAd;
    private BottomSheetDialog exitBottomSheet;
    private BottomSheetDialog noInternetBottomSheet;
    private BottomSheetDialog errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityQuizScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.optionA.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.checkAnswer(QuizScreen.this.binding.optionA);
            }
        });
        this.binding.optionB.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.checkAnswer(QuizScreen.this.binding.optionB);
            }
        });
        this.binding.optionC.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.checkAnswer(QuizScreen.this.binding.optionC);
            }
        });
        this.binding.optionD.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.checkAnswer(QuizScreen.this.binding.optionD);
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.binding.questionLayout.setVisibility(8);
        this.getQuizData();
        this.getDifficulty();
        this.initSoundEffects();
    }

    void initSoundEffects() {
        this.quizBgMusic = MediaPlayer.create((Context)this, (int)2131820549);
        this.quizBgMusic.setLooping(true);
        this.correctAnswerMusic = MediaPlayer.create((Context)this, (int)2131820545);
        this.wrongAnswerMusic = MediaPlayer.create((Context)this, (int)2131820550);
    }

    void getQuizData() {
        this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
        this.nativeAdId = this.getIntent().getStringExtra("nativeAdId");
        this.interstitialAdId = this.getIntent().getStringExtra("interstitialAdId");
        this.rewardedAdId = this.getIntent().getStringExtra("rewardedAdId");
        this.quizId = this.getIntent().getIntExtra("quizId", 0);
        this.quizName = this.getIntent().getStringExtra("quizName");
        this.quizIcon = this.getIntent().getStringExtra("quizIcon");
        this.quizEntryFee = this.getIntent().getIntExtra("quizEntryFee", 0);
        this.quizColor = this.getIntent().getIntExtra("quizColorCode", 0);
        this.easy = this.getIntent().getIntExtra("quizDifficultyEasy", 0);
        this.medium = this.getIntent().getIntExtra("quizDifficultyMedium", 0);
        this.hard = this.getIntent().getIntExtra("quizDifficultyHard", 0);
        this.questionLimit = this.getIntent().getIntExtra("quizQuestionLimit", 0);
        this.livesAvailable = this.getIntent().getIntExtra("quizLivesAvailable", 0);
        this.time = this.getIntent().getIntExtra("quizTimeAvailable", 0);
        this.prizePerQuestion = this.getIntent().getFloatExtra("quizPrizePerQuestion", this.prizePerQuestion);
    }

    private void getQuestions() {
        if (this.quizId == 0 || this.questionLimit == 0 || this.livesAvailable == 0) {
            this.quizId = this.getIntent().getIntExtra("quizId", 0);
            this.questionLimit = this.getIntent().getIntExtra("quizQuestionLimit", 0);
            this.livesAvailable = this.getIntent().getIntExtra("quizLivesAvailable", 0);
        }
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<GetQuestions> getQuestionsCall = ApiController.getInstance().getApi().getQuestions(this.quizId, this.difficulty, this.questionLimit);
            getQuestionsCall.enqueue((Callback)new Callback<GetQuestions>(){

                public void onResponse(Call<GetQuestions> call, Response<GetQuestions> response) {
                    if (((GetQuestions)response.body()).getStatusCode() == 0) {
                        QuizScreen.this.binding.questionLayout.setVisibility(0);
                        QuizScreen.this.questionList = ((GetQuestions)response.body()).getQuestions();
                        QuizScreen.this.setQuizData(QuizScreen.this.questionList);
                        QuizScreen.this.loadInterstitialAd(QuizScreen.this.interstitialAdId);
                        QuizScreen.this.loadNativeAd(QuizScreen.this.binding.nativeAdPlaceHolder);
                    } else if (((GetQuestions)response.body()).getStatusCode() == 1) {
                        QuizzeSnackBar.showSnackBar((Context)QuizScreen.this, (View)QuizScreen.this.binding.getRoot(), QuizScreen.this.getResources().getString(2131886355), QuizScreen.this.getResources().getColor(2131034796));
                    } else {
                        QuizScreen.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<GetQuestions> call, Throwable t) {
                    Log.d((String)QuizScreen.TAG, (String)("getQuestionCallFailure = " + t.getLocalizedMessage()));
                    QuizScreen.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    private void getDifficulty() {
        if (this.easy + this.medium + this.hard == 0) {
            this.easy = this.getIntent().getIntExtra("quizDifficultyEasy", 1);
            this.medium = this.getIntent().getIntExtra("quizDifficultyMedium", 0);
            this.hard = this.getIntent().getIntExtra("quizDifficultyHard", 0);
        } else if (this.easy + this.medium + this.hard >= 2) {
            this.showDifficultySelectionBottomSheet();
        } else {
            this.difficulty = this.easy == 1 ? "EASY" : (this.medium == 1 ? "MEDIUM" : "HARD");
        }
    }

    private void showDifficultySelectionBottomSheet() {
        this.difficultySelectionBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131493009, (ViewGroup)this.findViewById(2131296502), false);
        this.difficultySelectionBottomSheet.setContentView(view);
        this.difficultySelectionBottomSheet.setCancelable(false);
        TextView easyButton = (TextView)view.findViewById(2131296523);
        TextView mediumButton = (TextView)view.findViewById(2131296728);
        TextView hardButton = (TextView)view.findViewById(2131296596);
        if (this.easy == 0) {
            easyButton.setVisibility(8);
        }
        if (this.medium == 0) {
            mediumButton.setVisibility(8);
        }
        if (this.hard == 0) {
            hardButton.setVisibility(8);
        }
        easyButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.selectDifficulty("EASY");
            }
        });
        mediumButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.selectDifficulty("MEDIUM");
            }
        });
        hardButton.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.selectDifficulty("HARD");
            }
        });
        if (!this.isFinishing()) {
            this.difficultySelectionBottomSheet.show();
        }
    }

    void selectDifficulty(String difficultyLevel) {
        this.difficulty = difficultyLevel;
        this.difficultySelectionBottomSheet.cancel();
        this.binding.questionLayout.setVisibility(8);
        this.getQuestions();
    }

    private void setQuizData(List<Question> questionList) {
        this.binding.userLives.setText((CharSequence)String.valueOf(this.livesAvailable));
        this.binding.userScore.setText((CharSequence)String.valueOf(this.score));
        this.index = this.currentIndex + 1;
        String questionCount = this.getResources().getString(2131886389) + ' ' + this.index + ' ' + this.getResources().getString(2131886390) + ' ' + this.questionLimit;
        this.binding.questionCount.setText((CharSequence)questionCount);
        this.question = questionList.get(this.currentIndex);
        this.binding.question.setText((CharSequence)this.question.getQuestion());
        if (!this.question.getImage().trim().isEmpty()) {
            this.binding.questionImage.setVisibility(0);
            Picasso.get().load("https://gaou.biogenesis.fr/" + this.question.getImage()).into(this.binding.questionImage);
        } else {
            this.binding.questionImage.setVisibility(8);
        }
        if (this.question.getOptionA().isEmpty()) {
            this.binding.optionA.setVisibility(8);
        } else {
            this.binding.optionA.setVisibility(0);
        }
        if (this.question.getOptionB().isEmpty()) {
            this.binding.optionB.setVisibility(8);
        } else {
            this.binding.optionB.setVisibility(0);
        }
        if (this.question.getOptionC().isEmpty()) {
            this.binding.optionC.setVisibility(8);
        } else {
            this.binding.optionC.setVisibility(0);
        }
        if (this.question.getOptionD().isEmpty()) {
            this.binding.optionD.setVisibility(8);
        } else {
            this.binding.optionD.setVisibility(0);
        }
        this.binding.optionA.setText((CharSequence)this.question.getOptionA());
        this.binding.optionB.setText((CharSequence)this.question.getOptionB());
        this.binding.optionC.setText((CharSequence)this.question.getOptionC());
        this.binding.optionD.setText((CharSequence)this.question.getOptionD());
        this.quizBgMusic.start();
        this.quizCountDownTimer();
    }

    void checkAnswer(TextView userAnswer) {
        ++this.questionAttempted;
        if (this.quizTimer != null) {
            this.quizTimer.cancel();
        }
        if (this.quizBgMusic.isPlaying()) {
            this.quizBgMusic.pause();
        }
        this.binding.optionA.setEnabled(false);
        this.binding.optionB.setEnabled(false);
        this.binding.optionC.setEnabled(false);
        this.binding.optionD.setEnabled(false);
        if (userAnswer.getText().toString().equals(this.question.getAnswer())) {
            this.correctAnswerMusic.start();
            userAnswer.setBackground(ContextCompat.getDrawable((Context)this, (int)2131165351));
            this.score += 5;
            ++this.correctAnswers;
            this.binding.userScore.setText((CharSequence)(this.score + ""));
        } else {
            this.wrongAnswerMusic.start();
            userAnswer.setBackground(ContextCompat.getDrawable((Context)this, (int)2131165514));
            --this.livesAvailable;
            ++this.wrongAnswers;
            this.binding.userLives.setText((CharSequence)(this.livesAvailable + ""));
        }
        this.goToNextQuestion();
    }

    void resetAnswers() {
        this.binding.optionA.setEnabled(true);
        this.binding.optionB.setEnabled(true);
        this.binding.optionC.setEnabled(true);
        this.binding.optionD.setEnabled(true);
        this.binding.optionA.setBackground(ContextCompat.getDrawable((Context)this, (int)2131165500));
        this.binding.optionB.setBackground(ContextCompat.getDrawable((Context)this, (int)2131165500));
        this.binding.optionC.setBackground(ContextCompat.getDrawable((Context)this, (int)2131165500));
        this.binding.optionD.setBackground(ContextCompat.getDrawable((Context)this, (int)2131165500));
    }

    void quizCountDownTimer() {
        this.quizTimer = new CountDownTimer((long)this.time * 1000L, 1000L){

            public void onTick(long millisUntilFinished) {
                QuizScreen.this.binding.quizTimerProgressBar.setMax(QuizScreen.this.time);
                QuizScreen.this.millisSecondLeft = millisUntilFinished;
                int timeLeft = (int)millisUntilFinished / 1000;
                if (Build.VERSION.SDK_INT >= 24) {
                    QuizScreen.this.binding.quizTimerProgressBar.setProgress(timeLeft, true);
                } else {
                    QuizScreen.this.binding.quizTimerProgressBar.setProgress(timeLeft);
                }
                if ((double)timeLeft > (double)QuizScreen.this.time * 0.65) {
                    QuizScreen.this.binding.quizTimerProgressBar.setIndicatorColor(new int[]{QuizScreen.this.getResources().getColor(2131034780)});
                } else if ((double)timeLeft > (double)QuizScreen.this.time * 0.25) {
                    QuizScreen.this.binding.quizTimerProgressBar.setIndicatorColor(new int[]{QuizScreen.this.getResources().getColor(2131034796)});
                } else {
                    QuizScreen.this.binding.quizTimerProgressBar.setIndicatorColor(new int[]{QuizScreen.this.getResources().getColor(2131034225)});
                }
            }

            public void onFinish() {
                --QuizScreen.this.livesAvailable;
                ++QuizScreen.this.leavedQuestions;
                QuizScreen.this.binding.userLives.setText((CharSequence)String.valueOf(QuizScreen.this.livesAvailable));
                QuizScreen.this.goToNextQuestion();
            }
        }.start();
    }

    void goToNextQuestion() {
        if (this.index < this.questionLimit) {
            if (this.livesAvailable > 0) {
                CountDownTimer countDownTimer = new CountDownTimer(2500L, 1000L){

                    public void onTick(long millisUntilFinished) {
                        if (millisUntilFinished / 1000L == 1L) {
                            QuizScreen.this.binding.quizAnimation.setSpeed(2.0f);
                            QuizScreen.this.binding.quizAnimation.playAnimation();
                            QuizScreen.this.binding.questionLayout.setVisibility(8);
                            QuizScreen.this.binding.loader.setVisibility(0);
                        }
                    }

                    public void onFinish() {
                        ++QuizScreen.this.currentIndex;
                        QuizScreen.this.resetAnswers();
                        QuizScreen.this.binding.questionLayout.setVisibility(0);
                        QuizScreen.this.binding.loader.setVisibility(8);
                        QuizScreen.this.setQuizData(QuizScreen.this.questionList);
                    }
                };
                countDownTimer.start();
            } else {
                this.showNoLivesBottomSheet();
            }
        } else {
            this.showQuizFinishInterstitialAd();
        }
    }

    public void onBackPressed() {
        this.showExitBottomSheet();
    }

    public void showNoLivesBottomSheet() {
        if (this.quizBgMusic.isPlaying()) {
            this.quizBgMusic.stop();
        }
        this.noLivesBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492997, (ViewGroup)((ConstraintLayout)this.binding.getRoot().findViewById(2131296784)), false);
        this.noLivesBottomSheet.setContentView(view);
        this.noLivesBottomSheet.setCancelable(false);
        final MaterialCardView watchAdBtn = (MaterialCardView)view.findViewById(2131297134);
        Button endQuizBtn = (Button)view.findViewById(2131296530);
        final LottieAnimationView progressBar = (LottieAnimationView)view.findViewById(2131296359);
        watchAdBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QuizScreen.this.adEnabled == 1) {
                    progressBar.setVisibility(0);
                    watchAdBtn.setVisibility(8);
                    QuizScreen.this.loadRewardedAd(watchAdBtn, progressBar, QuizScreen.this.rewardedAdId);
                } else {
                    QuizzeSnackBar.showSnackBar((Context)QuizScreen.this, view, QuizScreen.this.getResources().getString(2131886348), QuizScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        endQuizBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.showEndQuizInterstitialAd();
            }
        });
        if (!this.isFinishing()) {
            this.noLivesBottomSheet.show();
        }
    }

    public void loadNativeAd(final FrameLayout frameLayout) {
        if (this.adEnabled == 1) {
            AdLoader.Builder builder = new AdLoader.Builder((Context)this, this.nativeAdId);
            builder.forNativeAd(new NativeAd.OnNativeAdLoadedListener(){

                public void onNativeAdLoaded(@NonNull NativeAd nativeAd) {
                    NativeAdView nativeAdView = (NativeAdView)QuizScreen.this.getLayoutInflater().inflate(2131493014, null);
                    QuizScreen.this.populateNativeAd(nativeAd, nativeAdView);
                    frameLayout.removeAllViews();
                    frameLayout.addView((View)nativeAdView);
                }
            });
            AdLoader adLoader = builder.withAdListener(new AdListener(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    Log.d((String)QuizScreen.TAG, (String)("Failed to load native ad =  " + loadAdError));
                }
            }).build();
            adLoader.loadAd(new AdRequest.Builder().build());
        }
    }

    public void populateNativeAd(NativeAd nativeAd, NativeAdView nativeAdView) {
        nativeAdView.setIconView(nativeAdView.findViewById(2131296347));
        nativeAdView.setHeadlineView(nativeAdView.findViewById(2131296344));
        nativeAdView.setCallToActionView(nativeAdView.findViewById(2131296338));
        nativeAdView.setBodyView(nativeAdView.findViewById(2131296337));
        if (nativeAd != null) {
            ((TextView)nativeAdView.getHeadlineView()).setText((CharSequence)nativeAd.getHeadline());
            if (nativeAd.getIcon() == null) {
                nativeAdView.getIconView().setVisibility(4);
            } else {
                nativeAdView.getIconView().setVisibility(0);
                ((ImageView)nativeAdView.getIconView()).setImageDrawable(nativeAd.getIcon().getDrawable());
            }
            if (nativeAd.getBody() == null) {
                nativeAdView.getBodyView().setVisibility(4);
            } else {
                nativeAdView.getBodyView().setVisibility(0);
                ((TextView)nativeAdView.getBodyView()).setText((CharSequence)nativeAd.getBody());
            }
            if (nativeAd.getCallToAction() == null) {
                nativeAdView.getCallToActionView().setVisibility(4);
            } else {
                nativeAdView.getCallToActionView().setVisibility(0);
                ((Button)nativeAdView.getCallToActionView()).setText((CharSequence)nativeAd.getCallToAction());
            }
            nativeAdView.setNativeAd(nativeAd);
        }
    }

    public void loadInterstitialAd(String adId) {
        if (this.adEnabled == 1) {
            AdRequest adRequest = new AdRequest.Builder().build();
            InterstitialAd.load((Context)this, (String)adId, (AdRequest)adRequest, (InterstitialAdLoadCallback)new InterstitialAdLoadCallback(){

                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                    super.onAdFailedToLoad(loadAdError);
                    QuizScreen.this.mInterstitialAd = null;
                    Log.d((String)QuizScreen.TAG, (String)"Failed to load interstitial ad");
                }

                public void onAdLoaded(@NonNull InterstitialAd interstitialAd) {
                    super.onAdLoaded((Object)interstitialAd);
                    QuizScreen.this.mInterstitialAd = interstitialAd;
                }
            });
        }
    }

    public void showQuizFinishInterstitialAd() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.show((Activity)this);
            this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent();
                    QuizScreen.this.goToQuizResultScreen();
                }
            });
        } else {
            this.goToQuizResultScreen();
        }
    }

    public void loadRewardedAd(final MaterialCardView watchAdBtn, final LottieAnimationView adProgressBar, String adId) {
        AdRequest adRequest = new AdRequest.Builder().build();
        RewardedAd.load((Context)this, (String)adId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

            public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                super.onAdFailedToLoad(loadAdError);
                Log.d((String)QuizScreen.TAG, (String)"Failed to load rewarded ad");
                watchAdBtn.setVisibility(0);
                adProgressBar.setVisibility(8);
                QuizzeSnackBar.showSnackBar((Context)QuizScreen.this, (View)QuizScreen.this.binding.getRoot(), QuizScreen.this.getResources().getString(2131886348), QuizScreen.this.getResources().getColor(2131034225));
                QuizScreen.this.mRewardedAd = null;
            }

            public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                super.onAdLoaded((Object)rewardedAd);
                QuizScreen.this.mRewardedAd = rewardedAd;
                QuizScreen.this.mRewardedAd.show((Activity)QuizScreen.this, new OnUserEarnedRewardListener(){

                    public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                        if (QuizScreen.this.noLivesBottomSheet.isShowing()) {
                            QuizScreen.this.noLivesBottomSheet.cancel();
                        }
                        ++QuizScreen.this.livesAvailable;
                        QuizScreen.this.goToNextQuestion();
                    }
                });
            }
        });
    }

    public void showEndQuizInterstitialAd() {
        if (this.mInterstitialAd != null) {
            this.mInterstitialAd.show((Activity)this);
            this.mInterstitialAd.setFullScreenContentCallback(new FullScreenContentCallback(){

                public void onAdDismissedFullScreenContent() {
                    super.onAdDismissedFullScreenContent();
                    QuizScreen.this.goToLoseActivity();
                }
            });
        } else {
            Log.d((String)TAG, (String)"interstitial ad is null");
            this.goToLoseActivity();
        }
    }

    public void goToLoseActivity() {
        Intent intent = new Intent((Context)this, LoseActivity.class);
        intent.putExtra("adEnabled", this.adEnabled);
        intent.putExtra("nativeAdId", this.nativeAdId);
        intent.putExtra("interstitialAdId", this.interstitialAdId);
        intent.putExtra("rewardedAdId", this.rewardedAdId);
        this.startActivity(intent);
        this.finish();
    }

    public void goToQuizResultScreen() {
        this.quizBgMusic.stop();
        this.quizBgMusic.release();
        this.wrongAnswerMusic.release();
        this.correctAnswerMusic.release();
        Intent intent = new Intent((Context)this, QuizResultScreen.class);
        intent.putExtra("quizName", this.quizName);
        intent.putExtra("quizIcon", this.quizIcon);
        intent.putExtra("quizEntryFee", this.quizEntryFee);
        intent.putExtra("quizColorCode", this.quizColor);
        intent.putExtra("quizQuestionLimit", this.questionLimit);
        intent.putExtra("quizQuestionAttempted", this.questionAttempted);
        intent.putExtra("quizCorrectAnswers", this.correctAnswers);
        intent.putExtra("quizWrongAnswers", this.wrongAnswers);
        intent.putExtra("quizUserScore", this.score);
        intent.putExtra("quizPrizePerQuestion", this.prizePerQuestion);
        intent.putExtra("adEnabled", this.adEnabled);
        intent.putExtra("nativeAdId", this.nativeAdId);
        intent.putExtra("interstitialAdId", this.interstitialAdId);
        intent.putExtra("rewardedAdId", this.rewardedAdId);
        this.startActivity(intent);
        this.finish();
    }

    public void showExitBottomSheet() {
        if (this.quizBgMusic.isPlaying()) {
            this.quizBgMusic.pause();
            this.quizTimer.cancel();
        }
        this.exitBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492935, (ViewGroup)this.binding.getRoot().findViewById(2131296536), false);
        this.exitBottomSheet.setContentView(view);
        this.exitBottomSheet.setCancelable(false);
        Button yesBtn = (Button)view.findViewById(2131297157);
        Button noBtn = (Button)view.findViewById(2131296781);
        TextView exitTitle = (TextView)view.findViewById(2131296535);
        TextView exitSubText = (TextView)view.findViewById(2131296537);
        exitTitle.setText((CharSequence)String.format(this.getResources().getString(2131886192), this.quizName));
        exitSubText.setText((CharSequence)this.getResources().getString(2131886392));
        yesBtn.setText((CharSequence)this.getResources().getString(2131886191));
        noBtn.setText((CharSequence)this.getResources().getString(2131886163));
        yesBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (QuizScreen.this.quizTimer != null) {
                    QuizScreen.this.quizTimer.cancel();
                }
                QuizScreen.this.quizBgMusic.release();
                QuizScreen.this.wrongAnswerMusic.release();
                QuizScreen.this.correctAnswerMusic.release();
                QuizScreen.this.showEndQuizInterstitialAd();
            }
        });
        noBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.exitBottomSheet.cancel();
                QuizScreen.this.quizBgMusic.start();
                QuizScreen.this.resumeQuiz(QuizScreen.this.millisSecondLeft);
            }
        });
        if (!this.isFinishing()) {
            this.exitBottomSheet.show();
        }
    }

    private void resumeQuiz(long timeLeftInMillis) {
        this.quizTimer = new CountDownTimer(timeLeftInMillis, 1000L){

            public void onTick(long millisUntilFinished) {
                QuizScreen.this.binding.quizTimerProgressBar.setMax(QuizScreen.this.time);
                QuizScreen.this.millisSecondLeft = millisUntilFinished;
                int timeLeft = (int)millisUntilFinished / 1000;
                if (Build.VERSION.SDK_INT >= 24) {
                    QuizScreen.this.binding.quizTimerProgressBar.setProgress(timeLeft, true);
                } else {
                    QuizScreen.this.binding.quizTimerProgressBar.setProgress(timeLeft);
                }
                if ((double)timeLeft > (double)QuizScreen.this.time * 0.65) {
                    QuizScreen.this.binding.quizTimerProgressBar.setIndicatorColor(new int[]{QuizScreen.this.getResources().getColor(2131034780)});
                } else if ((double)timeLeft > (double)QuizScreen.this.time * 0.25) {
                    QuizScreen.this.binding.quizTimerProgressBar.setIndicatorColor(new int[]{QuizScreen.this.getResources().getColor(2131034796)});
                } else {
                    QuizScreen.this.binding.quizTimerProgressBar.setIndicatorColor(new int[]{QuizScreen.this.getResources().getColor(2131034225)});
                }
            }

            public void onFinish() {
                --QuizScreen.this.livesAvailable;
                ++QuizScreen.this.leavedQuestions;
                QuizScreen.this.binding.userLives.setText((CharSequence)String.valueOf(QuizScreen.this.livesAvailable));
                QuizScreen.this.goToNextQuestion();
            }
        }.start();
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)QuizScreen.this)) {
                    QuizScreen.this.noInternetBottomSheet.cancel();
                    QuizScreen.this.getQuestions();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)QuizScreen.this, view, QuizScreen.this.getResources().getString(2131886351), QuizScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.startActivity(new Intent((Context)QuizScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                QuizScreen.this.errorOccurredBottomSheet.cancel();
                QuizScreen.this.getQuestions();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

