/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.PlayingHistoryAdapter;
import com.ElyStudio.leGaou.databinding.ActivityPlayingHistoryScreenBinding;
import com.ElyStudio.leGaou.models.GetPlayingHistory;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class PlayingHistoryScreen
extends AppCompat {
    ActivityPlayingHistoryScreenBinding binding;
    public static final String TAG = "PLAYING_HISTORY_SCREEN";
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityPlayingHistoryScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
    }

    protected void onStart() {
        super.onStart();
        this.getPlayingHistory();
    }

    private void getPlayingHistory() {
        Call<GetPlayingHistory> getPlayingHistoryCall = ApiController.getInstance().getApi().getPlayingHistoryCall(FirebaseAuth.getInstance().getUid());
        getPlayingHistoryCall.enqueue((Callback)new Callback<GetPlayingHistory>(){

            public void onResponse(Call<GetPlayingHistory> call, Response<GetPlayingHistory> response) {
                if (((GetPlayingHistory)response.body()).getStatusCode() == 0) {
                    if (((GetPlayingHistory)response.body()).getPlayingHistoryList() != null) {
                        PlayingHistoryScreen.this.binding.playingHistoryRecyclerview.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)PlayingHistoryScreen.this, 1, false));
                        PlayingHistoryScreen.this.binding.playingHistoryRecyclerview.setAdapter((RecyclerView.Adapter)new PlayingHistoryAdapter((Context)PlayingHistoryScreen.this, (Activity)PlayingHistoryScreen.this, ((GetPlayingHistory)response.body()).getPlayingHistoryList(), ((GetPlayingHistory)response.body()).getAdEnabled(), ((GetPlayingHistory)response.body()).getNativeAdId()));
                    }
                } else {
                    PlayingHistoryScreen.this.showErrorOccurredBottomSheet();
                }
            }

            public void onFailure(Call<GetPlayingHistory> call, Throwable t) {
                PlayingHistoryScreen.this.showErrorOccurredBottomSheet();
                Log.d((String)PlayingHistoryScreen.TAG, (String)("getPlayingHistoryCall Failure = " + t.getLocalizedMessage()));
            }
        });
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)PlayingHistoryScreen.this)) {
                    PlayingHistoryScreen.this.noInternetBottomSheet.cancel();
                    PlayingHistoryScreen.this.getPlayingHistory();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)PlayingHistoryScreen.this, view, PlayingHistoryScreen.this.getResources().getString(2131886351), PlayingHistoryScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlayingHistoryScreen.this.startActivity(new Intent((Context)PlayingHistoryScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                PlayingHistoryScreen.this.errorOccurredBottomSheet.cancel();
                PlayingHistoryScreen.this.getPlayingHistory();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

