/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.content.SharedPreferences;
import android.os.Bundle;
import android.view.MenuItem;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import com.ElyStudio.leGaou.databinding.ActivityMainBinding;
import com.ElyStudio.leGaou.fragment.AccountFragment;
import com.ElyStudio.leGaou.fragment.GamesFragment;
import com.ElyStudio.leGaou.fragment.HomeFragment;
import com.ElyStudio.leGaou.fragment.LeaderboardFragment;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.google.android.material.navigation.NavigationBarView;
import com.google.firebase.messaging.FirebaseMessaging;

public class MainActivity
extends AppCompat {
    ActivityMainBinding binding;
    SharedPreferences sharedPreferences;
    boolean isNotificationEnabled;
    boolean appMode;
    String selectedAppLanguage;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityMainBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.sharedPreferences = this.getSharedPreferences("APP_PREFERENCES", 0);
        this.isNotificationEnabled = this.sharedPreferences.getBoolean("notificationEnabled", false);
        this.appMode = this.sharedPreferences.getBoolean("appColorMode", false);
        if (this.isNotificationEnabled) {
            FirebaseMessaging.getInstance().subscribeToTopic("NOTIFICATIONS");
        } else {
            FirebaseMessaging.getInstance().unsubscribeFromTopic("NOTIFICATIONS");
        }
        this.getSupportFragmentManager().beginTransaction().replace(2131296560, (Fragment)new HomeFragment()).commit();
        this.binding.bottomNavigationBar.setOnItemSelectedListener(new NavigationBarView.OnItemSelectedListener(){

            public boolean onNavigationItemSelected(@NonNull MenuItem item) {
                Fragment currentFragment = null;
                switch (item.getItemId()) {
                    case 2131296606: {
                        currentFragment = new HomeFragment();
                        break;
                    }
                    case 2131296571: {
                        currentFragment = new GamesFragment();
                        break;
                    }
                    case 2131296668: {
                        currentFragment = new LeaderboardFragment();
                        break;
                    }
                    case 2131296306: {
                        currentFragment = new AccountFragment();
                    }
                }
                MainActivity.this.getSupportFragmentManager().beginTransaction().replace(2131296560, currentFragment).commit();
                return true;
            }
        });
    }
}

