/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.app.Activity;
import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.adapter.InviteeAdapter;
import com.ElyStudio.leGaou.databinding.ActivityInviteEarnScreenBinding;
import com.ElyStudio.leGaou.models.ApiResponse;
import com.ElyStudio.leGaou.models.InviteEarnData;
import com.ElyStudio.leGaou.models.Invitee;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.LoadAdError;
import com.google.android.gms.ads.OnUserEarnedRewardListener;
import com.google.android.gms.ads.rewarded.RewardItem;
import com.google.android.gms.ads.rewarded.RewardedAd;
import com.google.android.gms.ads.rewarded.RewardedAdLoadCallback;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import java.util.List;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class InviteEarnScreen
extends AppCompat {
    ActivityInviteEarnScreenBinding binding;
    String userInviteCode;
    String invitedBy;
    int adEnabled;
    String rewardedAdId;
    public static final String TAG = "INVITE_EARN_SCREEN";
    private RewardedAd mRewardedAd;
    int inviteSenderReward;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityInviteEarnScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.binding.copyInviteCodeBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String inviteCodeLabel = InviteEarnScreen.this.getResources().getString(2131886113) + ' ' + InviteEarnScreen.this.getResources().getString(2131886455);
                ClipboardManager clipboard = (ClipboardManager)InviteEarnScreen.this.getSystemService("clipboard");
                ClipData clip = ClipData.newPlainText((CharSequence)inviteCodeLabel, (CharSequence)InviteEarnScreen.this.userInviteCode);
                clipboard.setPrimaryClip(clip);
                QuizzeSnackBar.showSnackBar((Context)InviteEarnScreen.this, (View)InviteEarnScreen.this.binding.getInviteBonusBtn, InviteEarnScreen.this.getResources().getString(2131886226), InviteEarnScreen.this.getResources().getColor(2131034780));
            }
        });
        this.binding.getInviteBonusBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                String inputInviteCode = InviteEarnScreen.this.binding.inviteCodeEdittext.getText().toString().trim();
                if (inputInviteCode.equals("")) {
                    QuizzeSnackBar.showSnackBar((Context)InviteEarnScreen.this, (View)InviteEarnScreen.this.binding.getRoot(), InviteEarnScreen.this.getResources().getString(2131886181), InviteEarnScreen.this.getResources().getColor(2131034225));
                } else if (inputInviteCode.length() > 4) {
                    QuizzeSnackBar.showSnackBar((Context)InviteEarnScreen.this, (View)InviteEarnScreen.this.binding.getRoot(), InviteEarnScreen.this.getResources().getString(2131886225), InviteEarnScreen.this.getResources().getColor(2131034225));
                } else {
                    InviteEarnScreen.this.getInviteBonus(inputInviteCode);
                }
            }
        });
        this.binding.inviteNowBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                try {
                    String inviteMessage = String.format(InviteEarnScreen.this.getResources().getString(2131886112), InviteEarnScreen.this.getResources().getString(2131886113), InviteEarnScreen.this.userInviteCode, InviteEarnScreen.this.inviteSenderReward) + '\n';
                    Intent shareIntent = new Intent("android.intent.action.SEND");
                    shareIntent.setType("text/plain");
                    shareIntent.putExtra("android.intent.extra.SUBJECT", InviteEarnScreen.this.getResources().getString(2131886113));
                    String shareMessage = inviteMessage + "https://play.google.com/store/apps/details?id=" + "com.ElyStudio.leGaou" + "\n\n";
                    shareIntent.putExtra("android.intent.extra.TEXT", shareMessage);
                    InviteEarnScreen.this.startActivity(Intent.createChooser((Intent)shareIntent, (CharSequence)"choose one"));
                }
                catch (Exception e) {
                    Log.d((String)InviteEarnScreen.TAG, (String)("App Sharing Exception = " + e.getLocalizedMessage()));
                }
            }
        });
    }

    protected void onStart() {
        super.onStart();
        this.setInviteEarnData();
    }

    private void setInviteEarnData() {
        this.invitedBy = this.getIntent().getStringExtra("invitedBy");
        this.adEnabled = this.getIntent().getIntExtra("adEnabled", 0);
        this.rewardedAdId = this.getIntent().getStringExtra("rewardedAdId");
        if (this.invitedBy != null) {
            this.binding.inviteCodeEdittext.setVisibility(8);
            this.binding.getInviteBonusBtn.setVisibility(8);
            this.binding.haveAnyInviteCode.setVisibility(8);
        }
        this.userInviteCode = FirebaseAuth.getInstance().getUid().substring(0, 4);
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<InviteEarnData> getInviteEarnData = ApiController.getInstance().getApi().getInviteEarnData(this.userInviteCode);
            getInviteEarnData.enqueue((Callback)new Callback<InviteEarnData>(){

                public void onResponse(Call<InviteEarnData> call, Response<InviteEarnData> response) {
                    if (((InviteEarnData)response.body()).getStatusCode() == 0) {
                        String inviteEarnSubtext = String.format(InviteEarnScreen.this.getResources().getString(2131886228), InviteEarnScreen.this.getResources().getString(2131886113), ((InviteEarnData)response.body()).getInviteSenderReward(), ((InviteEarnData)response.body()).getInviteReceiverReward());
                        InviteEarnScreen.this.binding.subText.setText((CharSequence)inviteEarnSubtext);
                        InviteEarnScreen.this.binding.userInviteCode.setText((CharSequence)InviteEarnScreen.this.userInviteCode);
                        InviteEarnScreen.this.inviteSenderReward = ((InviteEarnData)response.body()).getInviteSenderReward();
                        if (((InviteEarnData)response.body()).getInviteeList() != null) {
                            InviteEarnScreen.this.setInviteesRecyclerView(((InviteEarnData)response.body()).getInviteeList(), (Context)InviteEarnScreen.this, ((InviteEarnData)response.body()).getInviteSenderReward());
                        }
                        if (InviteEarnScreen.this.adEnabled == 1) {
                            AdRequest adRequest = new AdRequest.Builder().build();
                            RewardedAd.load((Context)InviteEarnScreen.this, (String)InviteEarnScreen.this.rewardedAdId, (AdRequest)adRequest, (RewardedAdLoadCallback)new RewardedAdLoadCallback(){

                                public void onAdFailedToLoad(@NonNull LoadAdError loadAdError) {
                                    super.onAdFailedToLoad(loadAdError);
                                    Log.d((String)InviteEarnScreen.TAG, (String)("Failed to load rewarded ad = " + loadAdError));
                                    InviteEarnScreen.this.mRewardedAd = null;
                                }

                                public void onAdLoaded(@NonNull RewardedAd rewardedAd) {
                                    super.onAdLoaded((Object)rewardedAd);
                                    InviteEarnScreen.this.mRewardedAd = rewardedAd;
                                }
                            });
                        }
                    } else {
                        InviteEarnScreen.this.showErrorOccurredBottomSheet();
                    }
                }

                public void onFailure(Call<InviteEarnData> call, Throwable t) {
                    Log.d((String)InviteEarnScreen.TAG, (String)("getInviteEarnData Failure = " + t.getLocalizedMessage()));
                    InviteEarnScreen.this.showErrorOccurredBottomSheet();
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    private void getInviteBonus(String inviteCode) {
        this.binding.getInviteBonusBtn.setVisibility(8);
        this.binding.inviteCodeEdittext.setVisibility(8);
        this.binding.inviteProgressBar.setVisibility(0);
        if (inviteCode.equals(FirebaseAuth.getInstance().getUid().substring(0, 4))) {
            this.binding.getInviteBonusBtn.setVisibility(0);
            this.binding.inviteCodeEdittext.setVisibility(0);
            this.binding.inviteProgressBar.setVisibility(8);
            QuizzeSnackBar.showSnackBar((Context)this, (View)this.binding.getRoot(), this.getResources().getString(2131886450), this.getResources().getColor(2131034225));
        } else {
            Call<ApiResponse> getInviteBonus = ApiController.getInstance().getApi().getInviteBonus(FirebaseAuth.getInstance().getUid(), inviteCode, this.getResources().getString(2131886229), this.getResources().getString(2131886233));
            getInviteBonus.enqueue((Callback)new Callback<ApiResponse>(){

                public void onResponse(Call<ApiResponse> call, Response<ApiResponse> response) {
                    if (((ApiResponse)response.body()).getStatusCode() == 0) {
                        if (InviteEarnScreen.this.mRewardedAd != null) {
                            InviteEarnScreen.this.mRewardedAd.show((Activity)InviteEarnScreen.this, new OnUserEarnedRewardListener(){

                                public void onUserEarnedReward(@NonNull RewardItem rewardItem) {
                                    InviteEarnScreen.this.updateInviteUi();
                                }
                            });
                        } else {
                            InviteEarnScreen.this.updateInviteUi();
                        }
                    } else if (((ApiResponse)response.body()).getStatusCode() == 1) {
                        InviteEarnScreen.this.binding.getInviteBonusBtn.setVisibility(0);
                        InviteEarnScreen.this.binding.inviteCodeEdittext.setVisibility(0);
                        InviteEarnScreen.this.binding.inviteProgressBar.setVisibility(8);
                        QuizzeSnackBar.showSnackBar((Context)InviteEarnScreen.this, (View)InviteEarnScreen.this.binding.getRoot(), InviteEarnScreen.this.getResources().getString(2131886225), InviteEarnScreen.this.getResources().getColor(2131034225));
                    } else {
                        InviteEarnScreen.this.binding.getInviteBonusBtn.setVisibility(0);
                        InviteEarnScreen.this.binding.inviteCodeEdittext.setVisibility(0);
                        InviteEarnScreen.this.binding.inviteProgressBar.setVisibility(8);
                        QuizzeSnackBar.showSnackBar((Context)InviteEarnScreen.this, (View)InviteEarnScreen.this.binding.getRoot(), InviteEarnScreen.this.getResources().getString(2131886224), InviteEarnScreen.this.getResources().getColor(2131034225));
                    }
                }

                public void onFailure(Call<ApiResponse> call, Throwable t) {
                    InviteEarnScreen.this.binding.getInviteBonusBtn.setVisibility(0);
                    InviteEarnScreen.this.binding.inviteCodeEdittext.setVisibility(0);
                    InviteEarnScreen.this.binding.inviteProgressBar.setVisibility(8);
                    Log.d((String)InviteEarnScreen.TAG, (String)("getInviteBonus failure = " + t.getLocalizedMessage()));
                    QuizzeSnackBar.showSnackBar((Context)InviteEarnScreen.this, (View)InviteEarnScreen.this.binding.getRoot(), InviteEarnScreen.this.getResources().getString(2131886416), InviteEarnScreen.this.getResources().getColor(2131034225));
                }
            });
        }
    }

    public void updateInviteUi() {
        this.binding.inviteCodeEdittext.setVisibility(8);
        this.binding.getInviteBonusBtn.setVisibility(8);
        this.binding.haveAnyInviteCode.setVisibility(8);
        this.binding.inviteProgressBar.setVisibility(8);
        QuizzeSnackBar.showSnackBar((Context)this, (View)this.binding.getRoot(), this.getResources().getString(2131886117), this.getResources().getColor(2131034780));
    }

    public void setInviteesRecyclerView(List<Invitee> inviteeList, Context context, int inviteeReward) {
        RecyclerView inviteeRecyclerView = this.binding.inviteeRecyclerview;
        LinearLayoutManager layoutManager = new LinearLayoutManager(context, 1, false);
        InviteeAdapter inviteeAdapter = new InviteeAdapter(context, inviteeList, inviteeReward);
        inviteeRecyclerView.setLayoutManager((RecyclerView.LayoutManager)layoutManager);
        inviteeRecyclerView.setAdapter((RecyclerView.Adapter)inviteeAdapter);
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)InviteEarnScreen.this)) {
                    InviteEarnScreen.this.noInternetBottomSheet.cancel();
                    InviteEarnScreen.this.setInviteEarnData();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)InviteEarnScreen.this, view, InviteEarnScreen.this.getResources().getString(2131886351), InviteEarnScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InviteEarnScreen.this.startActivity(new Intent((Context)InviteEarnScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                InviteEarnScreen.this.errorOccurredBottomSheet.cancel();
                InviteEarnScreen.this.setInviteEarnData();
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

