/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebChromeClient;
import android.webkit.WebResourceError;
import android.webkit.WebResourceRequest;
import android.webkit.WebSettings;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.ElyStudio.leGaou.activities.MainActivity;
import com.ElyStudio.leGaou.activities.SupportScreen;
import com.ElyStudio.leGaou.databinding.ActivityGameWebViewScreenBinding;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;

public class GameWebViewScreen
extends AppCompat {
    ActivityGameWebViewScreenBinding binding;
    String gameUrl;
    String gameName;
    public static final String TAG = "GAME_WEB_VIEW_SCREEN";
    BottomSheetDialog exitBottomSheet;
    BottomSheetDialog noInternetBottomSheet;
    BottomSheetDialog errorOccurredBottomSheet;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityGameWebViewScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
        this.setupGameWebView();
    }

    @SuppressLint(value={"SetJavaScriptEnabled"})
    private void setupGameWebView() {
        this.gameUrl = this.getIntent().getStringExtra("gameUrl");
        this.gameName = this.getIntent().getStringExtra("gameName");
        WebView webView = this.binding.gameWebView;
        WebSettings webSettings = webView.getSettings();
        webSettings.setJavaScriptEnabled(true);
        webSettings.setDomStorageEnabled(true);
        webView.setWebChromeClient(new WebChromeClient());
        webView.setWebViewClient(new WebViewClient(){

            public void onReceivedError(WebView view, WebResourceRequest request, WebResourceError error) {
                super.onReceivedError(view, request, error);
                Log.d((String)GameWebViewScreen.TAG, (String)("WebView error = " + error.toString()));
                GameWebViewScreen.this.showErrorOccurredBottomSheet();
            }

            public void onPageStarted(WebView view, String url, Bitmap favicon) {
                super.onPageStarted(view, url, favicon);
            }
        });
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            webView.loadUrl(this.gameUrl);
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    public void showExitBottomSheet() {
        this.exitBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492935, (ViewGroup)this.binding.getRoot().findViewById(2131296536), false);
        this.exitBottomSheet.setContentView(view);
        Button yesBtn = (Button)view.findViewById(2131297157);
        Button noBtn = (Button)view.findViewById(2131296781);
        TextView exitTitle = (TextView)view.findViewById(2131296535);
        TextView exitSubText = (TextView)view.findViewById(2131296537);
        exitTitle.setText((CharSequence)String.format(this.getResources().getString(2131886190), this.gameName));
        exitSubText.setVisibility(8);
        yesBtn.setText((CharSequence)this.getResources().getString(2131886189));
        noBtn.setText((CharSequence)this.getResources().getString(2131886162));
        noBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GameWebViewScreen.this.exitBottomSheet.cancel();
            }
        });
        yesBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GameWebViewScreen.this.startActivity(new Intent((Context)GameWebViewScreen.this, MainActivity.class));
                GameWebViewScreen.this.finish();
                GameWebViewScreen.this.exitBottomSheet.cancel();
            }
        });
        if (!this.isFinishing()) {
            this.exitBottomSheet.show();
        }
    }

    public void onBackPressed() {
        if (this.binding.gameWebView.canGoBack()) {
            this.binding.gameWebView.goBack();
        } else {
            this.showExitBottomSheet();
        }
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)GameWebViewScreen.this)) {
                    GameWebViewScreen.this.noInternetBottomSheet.cancel();
                    GameWebViewScreen.this.binding.gameWebView.loadUrl(GameWebViewScreen.this.gameUrl);
                } else {
                    QuizzeSnackBar.showSnackBar((Context)GameWebViewScreen.this, view, GameWebViewScreen.this.getResources().getString(2131886351), GameWebViewScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }

    public void showErrorOccurredBottomSheet() {
        this.errorOccurredBottomSheet = new BottomSheetDialog((Context)this);
        View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.errorOccurredBottomSheet.setContentView(view);
        this.errorOccurredBottomSheet.setCancelable(false);
        Button contactSupportBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.errorOccurredBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.errorOccurredBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.errorOccurredBottomSheet.findViewById(2131296412);
        TextView bottomSheetSubText = (TextView)this.errorOccurredBottomSheet.findViewById(2131296411);
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886416));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886187));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165365));
        contactSupportBtn.setText((CharSequence)this.getResources().getString(2131886161));
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        contactSupportBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GameWebViewScreen.this.startActivity(new Intent((Context)GameWebViewScreen.this, SupportScreen.class));
            }
        });
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                GameWebViewScreen.this.errorOccurredBottomSheet.cancel();
                GameWebViewScreen.this.binding.gameWebView.loadUrl(GameWebViewScreen.this.gameUrl);
            }
        });
        if (!this.isFinishing()) {
            this.errorOccurredBottomSheet.show();
        }
    }
}

