/*
 * Decompiled with CFR 0.152.
 */
package com.ElyStudio.leGaou.activities;

import android.content.Context;
import android.os.Bundle;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import com.ElyStudio.leGaou.databinding.ActivityAboutUsScreenBinding;
import com.ElyStudio.leGaou.models.AboutApp;
import com.ElyStudio.leGaou.utilities.ApiController;
import com.ElyStudio.leGaou.utilities.AppCompat;
import com.ElyStudio.leGaou.utilities.CheckInternetConnection;
import com.ElyStudio.leGaou.utilities.QuizzeSnackBar;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

public class AboutUsScreen
extends AppCompat {
    ActivityAboutUsScreenBinding binding;
    BottomSheetDialog noInternetBottomSheet;
    public static final String TAG = "ABOUT_US_SCREEN";

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.binding = ActivityAboutUsScreenBinding.inflate(this.getLayoutInflater());
        this.setContentView((View)this.binding.getRoot());
    }

    protected void onStart() {
        super.onStart();
        this.getAboutApp();
    }

    private void getAboutApp() {
        if (CheckInternetConnection.isInternetConnected((Context)this)) {
            Call<AboutApp> getAboutAppCall = ApiController.getInstance().getApi().getAboutApp();
            getAboutAppCall.enqueue((Callback)new Callback<AboutApp>(){

                public void onResponse(Call<AboutApp> call, Response<AboutApp> response) {
                    if (((AboutApp)response.body()).getStatusCode() == 0) {
                        AboutUsScreen.this.binding.aboutUs.setText((CharSequence)((AboutApp)response.body()).getAboutUs());
                    }
                }

                public void onFailure(Call<AboutApp> call, Throwable t) {
                    Log.d((String)AboutUsScreen.TAG, (String)("getAboutAppCall Failure = " + t.getLocalizedMessage()));
                }
            });
        } else {
            this.showNoInternetBottomSheet();
        }
    }

    public void showNoInternetBottomSheet() {
        this.noInternetBottomSheet = new BottomSheetDialog((Context)this);
        final View view = LayoutInflater.from((Context)this).inflate(2131492934, (ViewGroup)this.findViewById(2131296534), false);
        this.noInternetBottomSheet.setContentView(view);
        Button contactSupportBtn = (Button)this.noInternetBottomSheet.findViewById(2131296410);
        Button tryAgainBtn = (Button)this.noInternetBottomSheet.findViewById(2131296404);
        ImageView bottomSheetIllustration = (ImageView)this.noInternetBottomSheet.findViewById(2131296403);
        TextView bottomSheetTitle = (TextView)this.noInternetBottomSheet.findViewById(2131296412);
        this.noInternetBottomSheet.setCancelable(false);
        TextView bottomSheetSubText = (TextView)this.noInternetBottomSheet.findViewById(2131296411);
        contactSupportBtn.setVisibility(8);
        tryAgainBtn.setText((CharSequence)this.getResources().getString(2131886426));
        tryAgainBtn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (CheckInternetConnection.isInternetConnected((Context)AboutUsScreen.this)) {
                    AboutUsScreen.this.noInternetBottomSheet.cancel();
                    AboutUsScreen.this.getAboutApp();
                } else {
                    QuizzeSnackBar.showSnackBar((Context)AboutUsScreen.this, view, AboutUsScreen.this.getResources().getString(2131886351), AboutUsScreen.this.getResources().getColor(2131034225));
                }
            }
        });
        bottomSheetTitle.setText((CharSequence)this.getResources().getString(2131886351));
        bottomSheetSubText.setText((CharSequence)this.getResources().getString(2131886352));
        bottomSheetIllustration.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)2131165481));
        if (!this.isFinishing()) {
            this.noInternetBottomSheet.show();
        }
    }
}

